@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.inputs

import com.pulumi.azurenative.devtestlab.inputs.DayDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of a daily schedule.
 * @property time The time of day the schedule will occur.
 */
public data class DayDetailsArgs(
    public val time: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.inputs.DayDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.inputs.DayDetailsArgs =
        com.pulumi.azurenative.devtestlab.inputs.DayDetailsArgs.builder()
            .time(time?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DayDetailsArgs].
 */
@PulumiTagMarker
public class DayDetailsArgsBuilder internal constructor() {
    private var time: Output<String>? = null

    /**
     * @param value The time of day the schedule will occur.
     */
    @JvmName("ltxgfoqjremeierk")
    public suspend fun time(`value`: Output<String>) {
        this.time = value
    }

    /**
     * @param value The time of day the schedule will occur.
     */
    @JvmName("qoqkjpasaihyyoga")
    public suspend fun time(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.time = mapped
    }

    internal fun build(): DayDetailsArgs = DayDetailsArgs(
        time = time,
    )
}
