@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.inputs

import com.pulumi.azurenative.devtestlab.inputs.EnvironmentDeploymentPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Properties of an environment deployment.
 * @property armTemplateId The Azure Resource Manager template's identifier.
 * @property parameters The parameters of the Azure Resource Manager template.
 */
public data class EnvironmentDeploymentPropertiesArgs(
    public val armTemplateId: Output<String>? = null,
    public val parameters: Output<List<ArmTemplateParameterPropertiesArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.inputs.EnvironmentDeploymentPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.devtestlab.inputs.EnvironmentDeploymentPropertiesArgs =
        com.pulumi.azurenative.devtestlab.inputs.EnvironmentDeploymentPropertiesArgs.builder()
            .armTemplateId(armTemplateId?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [EnvironmentDeploymentPropertiesArgs].
 */
@PulumiTagMarker
public class EnvironmentDeploymentPropertiesArgsBuilder internal constructor() {
    private var armTemplateId: Output<String>? = null

    private var parameters: Output<List<ArmTemplateParameterPropertiesArgs>>? = null

    /**
     * @param value The Azure Resource Manager template's identifier.
     */
    @JvmName("rkdftmrsvefnlbun")
    public suspend fun armTemplateId(`value`: Output<String>) {
        this.armTemplateId = value
    }

    /**
     * @param value The parameters of the Azure Resource Manager template.
     */
    @JvmName("qxdxdldngyijuajb")
    public suspend fun parameters(`value`: Output<List<ArmTemplateParameterPropertiesArgs>>) {
        this.parameters = value
    }

    @JvmName("jcpfkpgdswaybqas")
    public suspend fun parameters(vararg values: Output<ArmTemplateParameterPropertiesArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values The parameters of the Azure Resource Manager template.
     */
    @JvmName("qjwaghwsrxxclvge")
    public suspend fun parameters(values: List<Output<ArmTemplateParameterPropertiesArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value The Azure Resource Manager template's identifier.
     */
    @JvmName("tyelcjpjmedkkidg")
    public suspend fun armTemplateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.armTemplateId = mapped
    }

    /**
     * @param value The parameters of the Azure Resource Manager template.
     */
    @JvmName("xfrhdgqxpgqoeyel")
    public suspend fun parameters(`value`: List<ArmTemplateParameterPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument The parameters of the Azure Resource Manager template.
     */
    @JvmName("xcrownoujjoskjur")
    public suspend
    fun parameters(argument: List<suspend ArmTemplateParameterPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ArmTemplateParameterPropertiesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument The parameters of the Azure Resource Manager template.
     */
    @JvmName("svfrfryhhidmnnbv")
    public suspend fun parameters(
        vararg
        argument: suspend ArmTemplateParameterPropertiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ArmTemplateParameterPropertiesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument The parameters of the Azure Resource Manager template.
     */
    @JvmName("aviuehjwlwdqrkvy")
    public suspend
    fun parameters(argument: suspend ArmTemplateParameterPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ArmTemplateParameterPropertiesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values The parameters of the Azure Resource Manager template.
     */
    @JvmName("liktxrdwueuaimdx")
    public suspend fun parameters(vararg values: ArmTemplateParameterPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    internal fun build(): EnvironmentDeploymentPropertiesArgs = EnvironmentDeploymentPropertiesArgs(
        armTemplateId = armTemplateId,
        parameters = parameters,
    )
}
