@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.inputs

import com.pulumi.azurenative.devtestlab.inputs.GetEnvironmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand Specify the $expand query. Example: 'properties($select=deploymentProperties)'
 * @property labName The name of the lab.
 * @property name The name of the environment.
 * @property resourceGroupName The name of the resource group.
 * @property userName The name of the user profile.
 */
public data class GetEnvironmentPlainArgs(
    public val expand: String? = null,
    public val labName: String,
    public val name: String,
    public val resourceGroupName: String,
    public val userName: String,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.inputs.GetEnvironmentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.inputs.GetEnvironmentPlainArgs =
        com.pulumi.azurenative.devtestlab.inputs.GetEnvironmentPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .labName(labName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .userName(userName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEnvironmentPlainArgs].
 */
@PulumiTagMarker
public class GetEnvironmentPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var labName: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    private var userName: String? = null

    /**
     * @param value Specify the $expand query. Example: 'properties($select=deploymentProperties)'
     */
    @JvmName("jteopaoekcualdwn")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the lab.
     */
    @JvmName("mdynmlwogrnwnbve")
    public suspend fun labName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.labName = mapped
    }

    /**
     * @param value The name of the environment.
     */
    @JvmName("sxxdlwyulilpahwg")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("twqfxyehjddrvumn")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the user profile.
     */
    @JvmName("sfudkareapudogoq")
    public suspend fun userName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.userName = mapped
    }

    internal fun build(): GetEnvironmentPlainArgs = GetEnvironmentPlainArgs(
        expand = expand,
        labName = labName ?: throw PulumiNullFieldException("labName"),
        name = name ?: throw PulumiNullFieldException("name"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        userName = userName ?: throw PulumiNullFieldException("userName"),
    )
}
