@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.inputs

import com.pulumi.azurenative.devtestlab.inputs.GetVirtualNetworkPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand Specify the $expand query. Example: 'properties($expand=externalSubnets)'
 * @property labName The name of the lab.
 * @property name The name of the virtual network.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetVirtualNetworkPlainArgs(
    public val expand: String? = null,
    public val labName: String,
    public val name: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.inputs.GetVirtualNetworkPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.inputs.GetVirtualNetworkPlainArgs =
        com.pulumi.azurenative.devtestlab.inputs.GetVirtualNetworkPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .labName(labName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualNetworkPlainArgs].
 */
@PulumiTagMarker
public class GetVirtualNetworkPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var labName: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Specify the $expand query. Example: 'properties($expand=externalSubnets)'
     */
    @JvmName("oulkefbwdajvvceg")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the lab.
     */
    @JvmName("eumndtomfxtjnlgd")
    public suspend fun labName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.labName = mapped
    }

    /**
     * @param value The name of the virtual network.
     */
    @JvmName("liymrupltnltrleu")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("wjsmafwrufkehwex")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetVirtualNetworkPlainArgs = GetVirtualNetworkPlainArgs(
        expand = expand,
        labName = labName ?: throw PulumiNullFieldException("labName"),
        name = name ?: throw PulumiNullFieldException("name"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
