@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.inputs

import com.pulumi.azurenative.devtestlab.inputs.InboundNatRuleArgs.builder
import com.pulumi.azurenative.devtestlab.kotlin.enums.TransportProtocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A rule for NAT - exposing a VM's port (backendPort) on the public IP address using a load balancer.
 * @property backendPort The port to which the external traffic will be redirected.
 * @property frontendPort The external endpoint port of the inbound connection. Possible values range between 1 and 65535, inclusive. If unspecified, a value will be allocated automatically.
 * @property transportProtocol The transport protocol for the endpoint.
 */
public data class InboundNatRuleArgs(
    public val backendPort: Output<Int>? = null,
    public val frontendPort: Output<Int>? = null,
    public val transportProtocol: Output<Either<String, TransportProtocol>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.inputs.InboundNatRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.inputs.InboundNatRuleArgs =
        com.pulumi.azurenative.devtestlab.inputs.InboundNatRuleArgs.builder()
            .backendPort(backendPort?.applyValue({ args0 -> args0 }))
            .frontendPort(frontendPort?.applyValue({ args0 -> args0 }))
            .transportProtocol(
                transportProtocol?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [InboundNatRuleArgs].
 */
@PulumiTagMarker
public class InboundNatRuleArgsBuilder internal constructor() {
    private var backendPort: Output<Int>? = null

    private var frontendPort: Output<Int>? = null

    private var transportProtocol: Output<Either<String, TransportProtocol>>? = null

    /**
     * @param value The port to which the external traffic will be redirected.
     */
    @JvmName("iesqtryrfaeajmpg")
    public suspend fun backendPort(`value`: Output<Int>) {
        this.backendPort = value
    }

    /**
     * @param value The external endpoint port of the inbound connection. Possible values range between 1 and 65535, inclusive. If unspecified, a value will be allocated automatically.
     */
    @JvmName("xnjqupccyokbbiha")
    public suspend fun frontendPort(`value`: Output<Int>) {
        this.frontendPort = value
    }

    /**
     * @param value The transport protocol for the endpoint.
     */
    @JvmName("ogxeeiwtirwdujqa")
    public suspend fun transportProtocol(`value`: Output<Either<String, TransportProtocol>>) {
        this.transportProtocol = value
    }

    /**
     * @param value The port to which the external traffic will be redirected.
     */
    @JvmName("wqagpuiqtkdmlltq")
    public suspend fun backendPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendPort = mapped
    }

    /**
     * @param value The external endpoint port of the inbound connection. Possible values range between 1 and 65535, inclusive. If unspecified, a value will be allocated automatically.
     */
    @JvmName("poyerqatyyputedb")
    public suspend fun frontendPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frontendPort = mapped
    }

    /**
     * @param value The transport protocol for the endpoint.
     */
    @JvmName("bkbxqkrhqjnpphcd")
    public suspend fun transportProtocol(`value`: Either<String, TransportProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transportProtocol = mapped
    }

    /**
     * @param value The transport protocol for the endpoint.
     */
    @JvmName("cgjeocgxgidxjnim")
    public fun transportProtocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TransportProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transportProtocol = mapped
    }

    /**
     * @param value The transport protocol for the endpoint.
     */
    @JvmName("obreyjegncwdeyxm")
    public fun transportProtocol(`value`: TransportProtocol) {
        val toBeMapped = Either.ofRight<String, TransportProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transportProtocol = mapped
    }

    internal fun build(): InboundNatRuleArgs = InboundNatRuleArgs(
        backendPort = backendPort,
        frontendPort = frontendPort,
        transportProtocol = transportProtocol,
    )
}
