@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.inputs

import com.pulumi.azurenative.devtestlab.inputs.NotificationSettingsArgs.builder
import com.pulumi.azurenative.devtestlab.kotlin.enums.EnableStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Notification settings for a schedule.
 * @property emailRecipient The email recipient to send notifications to (can be a list of semi-colon separated email addresses).
 * @property notificationLocale The locale to use when sending a notification (fallback for unsupported languages is EN).
 * @property status If notifications are enabled for this schedule (i.e. Enabled, Disabled).
 * @property timeInMinutes Time in minutes before event at which notification will be sent.
 * @property webhookUrl The webhook URL to which the notification will be sent.
 */
public data class NotificationSettingsArgs(
    public val emailRecipient: Output<String>? = null,
    public val notificationLocale: Output<String>? = null,
    public val status: Output<Either<String, EnableStatus>>? = null,
    public val timeInMinutes: Output<Int>? = null,
    public val webhookUrl: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.inputs.NotificationSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.inputs.NotificationSettingsArgs =
        com.pulumi.azurenative.devtestlab.inputs.NotificationSettingsArgs.builder()
            .emailRecipient(emailRecipient?.applyValue({ args0 -> args0 }))
            .notificationLocale(notificationLocale?.applyValue({ args0 -> args0 }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .timeInMinutes(timeInMinutes?.applyValue({ args0 -> args0 }))
            .webhookUrl(webhookUrl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NotificationSettingsArgs].
 */
@PulumiTagMarker
public class NotificationSettingsArgsBuilder internal constructor() {
    private var emailRecipient: Output<String>? = null

    private var notificationLocale: Output<String>? = null

    private var status: Output<Either<String, EnableStatus>>? = null

    private var timeInMinutes: Output<Int>? = null

    private var webhookUrl: Output<String>? = null

    /**
     * @param value The email recipient to send notifications to (can be a list of semi-colon separated email addresses).
     */
    @JvmName("hkljbiiakpgxplvc")
    public suspend fun emailRecipient(`value`: Output<String>) {
        this.emailRecipient = value
    }

    /**
     * @param value The locale to use when sending a notification (fallback for unsupported languages is EN).
     */
    @JvmName("pjxdsegsvpcidehv")
    public suspend fun notificationLocale(`value`: Output<String>) {
        this.notificationLocale = value
    }

    /**
     * @param value If notifications are enabled for this schedule (i.e. Enabled, Disabled).
     */
    @JvmName("fjauqniyltpyeipf")
    public suspend fun status(`value`: Output<Either<String, EnableStatus>>) {
        this.status = value
    }

    /**
     * @param value Time in minutes before event at which notification will be sent.
     */
    @JvmName("ntrgdeoioclqybss")
    public suspend fun timeInMinutes(`value`: Output<Int>) {
        this.timeInMinutes = value
    }

    /**
     * @param value The webhook URL to which the notification will be sent.
     */
    @JvmName("kjclgwmvbgiwofiu")
    public suspend fun webhookUrl(`value`: Output<String>) {
        this.webhookUrl = value
    }

    /**
     * @param value The email recipient to send notifications to (can be a list of semi-colon separated email addresses).
     */
    @JvmName("ubrqrwtayifnbvkk")
    public suspend fun emailRecipient(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailRecipient = mapped
    }

    /**
     * @param value The locale to use when sending a notification (fallback for unsupported languages is EN).
     */
    @JvmName("pccmrtptoeajwlgj")
    public suspend fun notificationLocale(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationLocale = mapped
    }

    /**
     * @param value If notifications are enabled for this schedule (i.e. Enabled, Disabled).
     */
    @JvmName("edaihtesqpsnwwpj")
    public suspend fun status(`value`: Either<String, EnableStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value If notifications are enabled for this schedule (i.e. Enabled, Disabled).
     */
    @JvmName("lqfwvtuxnljrbnpy")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EnableStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value If notifications are enabled for this schedule (i.e. Enabled, Disabled).
     */
    @JvmName("euwwadibdhmacdyw")
    public fun status(`value`: EnableStatus) {
        val toBeMapped = Either.ofRight<String, EnableStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Time in minutes before event at which notification will be sent.
     */
    @JvmName("vhtmqupxkctehrdr")
    public suspend fun timeInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeInMinutes = mapped
    }

    /**
     * @param value The webhook URL to which the notification will be sent.
     */
    @JvmName("cetwlwyuleahekyq")
    public suspend fun webhookUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webhookUrl = mapped
    }

    internal fun build(): NotificationSettingsArgs = NotificationSettingsArgs(
        emailRecipient = emailRecipient,
        notificationLocale = notificationLocale,
        status = status,
        timeInMinutes = timeInMinutes,
        webhookUrl = webhookUrl,
    )
}
