@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.inputs

import com.pulumi.azurenative.devtestlab.inputs.SharedPublicIpAddressConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Properties of a virtual machine that determine how it is connected to a load balancer.
 * @property inboundNatRules The incoming NAT rules
 */
public data class SharedPublicIpAddressConfigurationArgs(
    public val inboundNatRules: Output<List<InboundNatRuleArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.devtestlab.inputs.SharedPublicIpAddressConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.devtestlab.inputs.SharedPublicIpAddressConfigurationArgs =
        com.pulumi.azurenative.devtestlab.inputs.SharedPublicIpAddressConfigurationArgs.builder()
            .inboundNatRules(
                inboundNatRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SharedPublicIpAddressConfigurationArgs].
 */
@PulumiTagMarker
public class SharedPublicIpAddressConfigurationArgsBuilder internal constructor() {
    private var inboundNatRules: Output<List<InboundNatRuleArgs>>? = null

    /**
     * @param value The incoming NAT rules
     */
    @JvmName("bvxnvstgqolvogvo")
    public suspend fun inboundNatRules(`value`: Output<List<InboundNatRuleArgs>>) {
        this.inboundNatRules = value
    }

    @JvmName("prtmlbyyaqcdnfsk")
    public suspend fun inboundNatRules(vararg values: Output<InboundNatRuleArgs>) {
        this.inboundNatRules = Output.all(values.asList())
    }

    /**
     * @param values The incoming NAT rules
     */
    @JvmName("lyiuhmcaorcuised")
    public suspend fun inboundNatRules(values: List<Output<InboundNatRuleArgs>>) {
        this.inboundNatRules = Output.all(values)
    }

    /**
     * @param value The incoming NAT rules
     */
    @JvmName("pboyvrsoylkfgkal")
    public suspend fun inboundNatRules(`value`: List<InboundNatRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inboundNatRules = mapped
    }

    /**
     * @param argument The incoming NAT rules
     */
    @JvmName("wslietwogbdngicc")
    public suspend fun inboundNatRules(argument: List<suspend InboundNatRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InboundNatRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.inboundNatRules = mapped
    }

    /**
     * @param argument The incoming NAT rules
     */
    @JvmName("woudhiugbwlremgu")
    public suspend fun inboundNatRules(
        vararg
        argument: suspend InboundNatRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            InboundNatRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.inboundNatRules = mapped
    }

    /**
     * @param argument The incoming NAT rules
     */
    @JvmName("waljraivlicfnenm")
    public suspend fun inboundNatRules(argument: suspend InboundNatRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InboundNatRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.inboundNatRules = mapped
    }

    /**
     * @param values The incoming NAT rules
     */
    @JvmName("abylcebkbhejdple")
    public suspend fun inboundNatRules(vararg values: InboundNatRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inboundNatRules = mapped
    }

    internal fun build(): SharedPublicIpAddressConfigurationArgs =
        SharedPublicIpAddressConfigurationArgs(
            inboundNatRules = inboundNatRules,
        )
}
