@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.inputs

import com.pulumi.azurenative.devtestlab.inputs.UserSecretStoreArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of a user's secret store.
 * @property keyVaultId The ID of the user's Key vault.
 * @property keyVaultUri The URI of the user's Key vault.
 */
public data class UserSecretStoreArgs(
    public val keyVaultId: Output<String>? = null,
    public val keyVaultUri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.inputs.UserSecretStoreArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.inputs.UserSecretStoreArgs =
        com.pulumi.azurenative.devtestlab.inputs.UserSecretStoreArgs.builder()
            .keyVaultId(keyVaultId?.applyValue({ args0 -> args0 }))
            .keyVaultUri(keyVaultUri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserSecretStoreArgs].
 */
@PulumiTagMarker
public class UserSecretStoreArgsBuilder internal constructor() {
    private var keyVaultId: Output<String>? = null

    private var keyVaultUri: Output<String>? = null

    /**
     * @param value The ID of the user's Key vault.
     */
    @JvmName("sfatjyyqpdnsoubl")
    public suspend fun keyVaultId(`value`: Output<String>) {
        this.keyVaultId = value
    }

    /**
     * @param value The URI of the user's Key vault.
     */
    @JvmName("ikintwwdxihxvuue")
    public suspend fun keyVaultUri(`value`: Output<String>) {
        this.keyVaultUri = value
    }

    /**
     * @param value The ID of the user's Key vault.
     */
    @JvmName("akmhmadpijrrmgjh")
    public suspend fun keyVaultId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultId = mapped
    }

    /**
     * @param value The URI of the user's Key vault.
     */
    @JvmName("ylycthnsyyparwjo")
    public suspend fun keyVaultUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultUri = mapped
    }

    internal fun build(): UserSecretStoreArgs = UserSecretStoreArgs(
        keyVaultId = keyVaultId,
        keyVaultUri = keyVaultUri,
    )
}
