@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Information about a VM from which a formula is to be created.
 * @property labVmId The identifier of the VM from which a formula is to be created.
 */
public data class FormulaPropertiesFromVmResponse(
    public val labVmId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.FormulaPropertiesFromVmResponse):
            FormulaPropertiesFromVmResponse = FormulaPropertiesFromVmResponse(
            labVmId = javaType.labVmId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
