@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Properties of an artifact source.
 * @property armTemplateFolderPath The folder containing Azure Resource Manager templates.
 * @property branchRef The artifact source's branch reference.
 * @property createdDate The artifact source's creation date.
 * @property displayName The artifact source's display name.
 * @property folderPath The folder containing artifacts.
 * @property id The identifier of the resource.
 * @property location The location of the resource.
 * @property name The name of the resource.
 * @property provisioningState The provisioning status of the resource.
 * @property securityToken The security token to authenticate to the artifact source.
 * @property sourceType The artifact source's type.
 * @property status Indicates if the artifact source is enabled (values: Enabled, Disabled).
 * @property tags The tags of the resource.
 * @property type The type of the resource.
 * @property uniqueIdentifier The unique immutable identifier of a resource (Guid).
 * @property uri The artifact source's URI.
 */
public data class GetArtifactSourceResult(
    public val armTemplateFolderPath: String? = null,
    public val branchRef: String? = null,
    public val createdDate: String,
    public val displayName: String? = null,
    public val folderPath: String? = null,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val securityToken: String? = null,
    public val sourceType: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val uniqueIdentifier: String,
    public val uri: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.GetArtifactSourceResult):
            GetArtifactSourceResult = GetArtifactSourceResult(
            armTemplateFolderPath = javaType.armTemplateFolderPath().map({ args0 -> args0 }).orElse(null),
            branchRef = javaType.branchRef().map({ args0 -> args0 }).orElse(null),
            createdDate = javaType.createdDate(),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            folderPath = javaType.folderPath().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            securityToken = javaType.securityToken().map({ args0 -> args0 }).orElse(null),
            sourceType = javaType.sourceType().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            uniqueIdentifier = javaType.uniqueIdentifier(),
            uri = javaType.uri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
