@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * An environment, which is essentially an ARM template deployment.
 * @property armTemplateDisplayName The display name of the Azure Resource Manager template that produced the environment.
 * @property createdByUser The creator of the environment.
 * @property deploymentProperties The deployment properties of the environment.
 * @property id The identifier of the resource.
 * @property location The location of the resource.
 * @property name The name of the resource.
 * @property provisioningState The provisioning status of the resource.
 * @property resourceGroupId The identifier of the resource group containing the environment's resources.
 * @property tags The tags of the resource.
 * @property type The type of the resource.
 * @property uniqueIdentifier The unique immutable identifier of a resource (Guid).
 */
public data class GetEnvironmentResult(
    public val armTemplateDisplayName: String? = null,
    public val createdByUser: String,
    public val deploymentProperties: EnvironmentDeploymentPropertiesResponse? = null,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val resourceGroupId: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val uniqueIdentifier: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.GetEnvironmentResult):
            GetEnvironmentResult = GetEnvironmentResult(
            armTemplateDisplayName = javaType.armTemplateDisplayName().map({ args0 -> args0 }).orElse(null),
            createdByUser = javaType.createdByUser(),
            deploymentProperties = javaType.deploymentProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.EnvironmentDeploymentPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            resourceGroupId = javaType.resourceGroupId(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            uniqueIdentifier = javaType.uniqueIdentifier(),
        )
    }
}
