@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A schedule.
 * @property createdDate The creation date of the schedule.
 * @property dailyRecurrence If the schedule will occur once each day of the week, specify the daily recurrence.
 * @property hourlyRecurrence If the schedule will occur multiple times a day, specify the hourly recurrence.
 * @property id The identifier of the resource.
 * @property location The location of the resource.
 * @property name The name of the resource.
 * @property notificationSettings Notification settings.
 * @property provisioningState The provisioning status of the resource.
 * @property status The status of the schedule (i.e. Enabled, Disabled)
 * @property tags The tags of the resource.
 * @property targetResourceId The resource ID to which the schedule belongs
 * @property taskType The task type of the schedule (e.g. LabVmsShutdownTask, LabVmAutoStart).
 * @property timeZoneId The time zone ID (e.g. China Standard Time, Greenland Standard Time, Pacific Standard time, etc.). The possible values for this property can be found in `IReadOnlyCollection<string> TimeZoneConverter.TZConvert.KnownWindowsTimeZoneIds` (https://github.com/mattjohnsonpint/TimeZoneConverter/blob/main/README.md)
 * @property type The type of the resource.
 * @property uniqueIdentifier The unique immutable identifier of a resource (Guid).
 * @property weeklyRecurrence If the schedule will occur only some days of the week, specify the weekly recurrence.
 */
public data class GetGlobalScheduleResult(
    public val createdDate: String,
    public val dailyRecurrence: DayDetailsResponse? = null,
    public val hourlyRecurrence: HourDetailsResponse? = null,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val notificationSettings: NotificationSettingsResponse? = null,
    public val provisioningState: String,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val targetResourceId: String? = null,
    public val taskType: String? = null,
    public val timeZoneId: String? = null,
    public val type: String,
    public val uniqueIdentifier: String,
    public val weeklyRecurrence: WeekDetailsResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.GetGlobalScheduleResult):
            GetGlobalScheduleResult = GetGlobalScheduleResult(
            createdDate = javaType.createdDate(),
            dailyRecurrence = javaType.dailyRecurrence().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.DayDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            hourlyRecurrence = javaType.hourlyRecurrence().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.HourDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            notificationSettings = javaType.notificationSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.NotificationSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            targetResourceId = javaType.targetResourceId().map({ args0 -> args0 }).orElse(null),
            taskType = javaType.taskType().map({ args0 -> args0 }).orElse(null),
            timeZoneId = javaType.timeZoneId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            uniqueIdentifier = javaType.uniqueIdentifier(),
            weeklyRecurrence = javaType.weeklyRecurrence().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.WeekDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
