@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A lab.
 * @property announcement The properties of any lab announcement associated with this lab
 * @property artifactsStorageAccount The lab's artifact storage account.
 * @property createdDate The creation date of the lab.
 * @property defaultPremiumStorageAccount The lab's default premium storage account.
 * @property defaultStorageAccount The lab's default storage account.
 * @property environmentPermission The access rights to be granted to the user when provisioning an environment
 * @property extendedProperties Extended properties of the lab used for experimental features
 * @property id The identifier of the resource.
 * @property labStorageType Type of storage used by the lab. It can be either Premium or Standard. Default is Premium.
 * @property loadBalancerId The load balancer used to for lab VMs that use shared IP address.
 * @property location The location of the resource.
 * @property mandatoryArtifactsResourceIdsLinux The ordered list of artifact resource IDs that should be applied on all Linux VM creations by default, prior to the artifacts specified by the user.
 * @property mandatoryArtifactsResourceIdsWindows The ordered list of artifact resource IDs that should be applied on all Windows VM creations by default, prior to the artifacts specified by the user.
 * @property name The name of the resource.
 * @property networkSecurityGroupId The Network Security Group attached to the lab VMs Network interfaces to restrict open ports.
 * @property premiumDataDiskStorageAccount The lab's premium data disk storage account.
 * @property premiumDataDisks The setting to enable usage of premium data disks.
 * When its value is 'Enabled', creation of standard or premium data disks is allowed.
 * When its value is 'Disabled', only creation of standard data disks is allowed.
 * @property provisioningState The provisioning status of the resource.
 * @property publicIpId The public IP address for the lab's load balancer.
 * @property support The properties of any lab support message associated with this lab
 * @property tags The tags of the resource.
 * @property type The type of the resource.
 * @property uniqueIdentifier The unique immutable identifier of a resource (Guid).
 * @property vaultName The lab's Key vault.
 * @property vmCreationResourceGroup The resource group in which all new lab virtual machines will be created. To let DevTest Labs manage resource group creation, set this value to null.
 */
public data class GetLabResult(
    public val announcement: LabAnnouncementPropertiesResponse? = null,
    public val artifactsStorageAccount: String,
    public val createdDate: String,
    public val defaultPremiumStorageAccount: String,
    public val defaultStorageAccount: String,
    public val environmentPermission: String? = null,
    public val extendedProperties: Map<String, String>? = null,
    public val id: String,
    public val labStorageType: String? = null,
    public val loadBalancerId: String,
    public val location: String? = null,
    public val mandatoryArtifactsResourceIdsLinux: List<String>? = null,
    public val mandatoryArtifactsResourceIdsWindows: List<String>? = null,
    public val name: String,
    public val networkSecurityGroupId: String,
    public val premiumDataDiskStorageAccount: String,
    public val premiumDataDisks: String? = null,
    public val provisioningState: String,
    public val publicIpId: String,
    public val support: LabSupportPropertiesResponse? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val uniqueIdentifier: String,
    public val vaultName: String,
    public val vmCreationResourceGroup: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.GetLabResult):
            GetLabResult = GetLabResult(
            announcement = javaType.announcement().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.LabAnnouncementPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            artifactsStorageAccount = javaType.artifactsStorageAccount(),
            createdDate = javaType.createdDate(),
            defaultPremiumStorageAccount = javaType.defaultPremiumStorageAccount(),
            defaultStorageAccount = javaType.defaultStorageAccount(),
            environmentPermission = javaType.environmentPermission().map({ args0 -> args0 }).orElse(null),
            extendedProperties = javaType.extendedProperties().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            id = javaType.id(),
            labStorageType = javaType.labStorageType().map({ args0 -> args0 }).orElse(null),
            loadBalancerId = javaType.loadBalancerId(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            mandatoryArtifactsResourceIdsLinux = javaType.mandatoryArtifactsResourceIdsLinux().map({ args0 ->
                args0
            }),
            mandatoryArtifactsResourceIdsWindows = javaType.mandatoryArtifactsResourceIdsWindows().map({ args0 ->
                args0
            }),
            name = javaType.name(),
            networkSecurityGroupId = javaType.networkSecurityGroupId(),
            premiumDataDiskStorageAccount = javaType.premiumDataDiskStorageAccount(),
            premiumDataDisks = javaType.premiumDataDisks().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            publicIpId = javaType.publicIpId(),
            support = javaType.support().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.LabSupportPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            uniqueIdentifier = javaType.uniqueIdentifier(),
            vaultName = javaType.vaultName(),
            vmCreationResourceGroup = javaType.vmCreationResourceGroup(),
        )
    }
}
