@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A container for a managed identity to execute DevTest lab services.
 * @property id The identifier of the resource.
 * @property identity The identity of the resource.
 * @property location The location of the resource.
 * @property name The name of the resource.
 * @property tags The tags of the resource.
 * @property type The type of the resource.
 */
public data class GetServiceRunnerResult(
    public val id: String,
    public val identity: IdentityPropertiesResponse? = null,
    public val location: String? = null,
    public val name: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.GetServiceRunnerResult):
            GetServiceRunnerResult = GetServiceRunnerResult(
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.IdentityPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
