@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A virtual network.
 * @property allowedSubnets The allowed subnets of the virtual network.
 * @property createdDate The creation date of the virtual network.
 * @property description The description of the virtual network.
 * @property externalProviderResourceId The Microsoft.Network resource identifier of the virtual network.
 * @property externalSubnets The external subnet properties.
 * @property id The identifier of the resource.
 * @property location The location of the resource.
 * @property name The name of the resource.
 * @property provisioningState The provisioning status of the resource.
 * @property subnetOverrides The subnet overrides of the virtual network.
 * @property tags The tags of the resource.
 * @property type The type of the resource.
 * @property uniqueIdentifier The unique immutable identifier of a resource (Guid).
 */
public data class GetVirtualNetworkResult(
    public val allowedSubnets: List<SubnetResponse>? = null,
    public val createdDate: String,
    public val description: String? = null,
    public val externalProviderResourceId: String? = null,
    public val externalSubnets: List<ExternalSubnetResponse>,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val subnetOverrides: List<SubnetOverrideResponse>? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val uniqueIdentifier: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.GetVirtualNetworkResult):
            GetVirtualNetworkResult = GetVirtualNetworkResult(
            allowedSubnets = javaType.allowedSubnets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.SubnetResponse.Companion.toKotlin(args0)
                })
            }),
            createdDate = javaType.createdDate(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            externalProviderResourceId = javaType.externalProviderResourceId().map({ args0 ->
                args0
            }).orElse(null),
            externalSubnets = javaType.externalSubnets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.ExternalSubnetResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            subnetOverrides = javaType.subnetOverrides().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.SubnetOverrideResponse.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            uniqueIdentifier = javaType.uniqueIdentifier(),
        )
    }
}
