@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties of a user's secret store.
 * @property keyVaultId The ID of the user's Key vault.
 * @property keyVaultUri The URI of the user's Key vault.
 */
public data class UserSecretStoreResponse(
    public val keyVaultId: String? = null,
    public val keyVaultUri: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.UserSecretStoreResponse):
            UserSecretStoreResponse = UserSecretStoreResponse(
            keyVaultId = javaType.keyVaultId().map({ args0 -> args0 }).orElse(null),
            keyVaultUri = javaType.keyVaultUri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
