@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.digitaltwins.kotlin

import com.pulumi.azurenative.digitaltwins.DigitalTwinArgs.builder
import com.pulumi.azurenative.digitaltwins.kotlin.enums.PublicNetworkAccess
import com.pulumi.azurenative.digitaltwins.kotlin.inputs.DigitalTwinsIdentityArgs
import com.pulumi.azurenative.digitaltwins.kotlin.inputs.DigitalTwinsIdentityArgsBuilder
import com.pulumi.azurenative.digitaltwins.kotlin.inputs.PrivateEndpointConnectionArgs
import com.pulumi.azurenative.digitaltwins.kotlin.inputs.PrivateEndpointConnectionArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The description of the DigitalTwins service.
 * Azure REST API version: 2023-01-31. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-03-01-preview.
 * ## Example Usage
 * ### Put a DigitalTwinsInstance resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var digitalTwin = new AzureNative.DigitalTwins.DigitalTwin("digitalTwin", new()
 *     {
 *         Location = "WestUS2",
 *         ResourceGroupName = "resRg",
 *         ResourceName = "myDigitalTwinsService",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/digitaltwins/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := digitaltwins.NewDigitalTwin(ctx, "digitalTwin", &digitaltwins.DigitalTwinArgs{
 * 			Location:          pulumi.String("WestUS2"),
 * 			ResourceGroupName: pulumi.String("resRg"),
 * 			ResourceName:      pulumi.String("myDigitalTwinsService"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.digitaltwins.DigitalTwin;
 * import com.pulumi.azurenative.digitaltwins.DigitalTwinArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var digitalTwin = new DigitalTwin("digitalTwin", DigitalTwinArgs.builder()
 *             .location("WestUS2")
 *             .resourceGroupName("resRg")
 *             .resourceName("myDigitalTwinsService")
 *             .build());
 *     }
 * }
 * ```
 * ### Put a DigitalTwinsInstance resource with publicNetworkAccess property
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var digitalTwin = new AzureNative.DigitalTwins.DigitalTwin("digitalTwin", new()
 *     {
 *         Location = "WestUS2",
 *         PublicNetworkAccess = "Enabled",
 *         ResourceGroupName = "resRg",
 *         ResourceName = "myDigitalTwinsService",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/digitaltwins/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := digitaltwins.NewDigitalTwin(ctx, "digitalTwin", &digitaltwins.DigitalTwinArgs{
 * 			Location:            pulumi.String("WestUS2"),
 * 			PublicNetworkAccess: pulumi.String("Enabled"),
 * 			ResourceGroupName:   pulumi.String("resRg"),
 * 			ResourceName:        pulumi.String("myDigitalTwinsService"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.digitaltwins.DigitalTwin;
 * import com.pulumi.azurenative.digitaltwins.DigitalTwinArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var digitalTwin = new DigitalTwin("digitalTwin", DigitalTwinArgs.builder()
 *             .location("WestUS2")
 *             .publicNetworkAccess("Enabled")
 *             .resourceGroupName("resRg")
 *             .resourceName("myDigitalTwinsService")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:digitaltwins:DigitalTwin myDigitalTwinsService /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DigitalTwins/digitalTwinsInstances/{resourceName}
 * ```
 * @property identity The managed identity for the DigitalTwinsInstance.
 * @property location The resource location.
 * @property privateEndpointConnections The private endpoint connections.
 * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
 * @property publicNetworkAccess Public network access for the DigitalTwinsInstance.
 * @property resourceGroupName The name of the resource group that contains the DigitalTwinsInstance.
 * @property resourceName The name of the DigitalTwinsInstance.
 * @property tags The resource tags.
 */
public data class DigitalTwinArgs(
    public val identity: Output<DigitalTwinsIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionArgs>>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.digitaltwins.DigitalTwinArgs> {
    override fun toJava(): com.pulumi.azurenative.digitaltwins.DigitalTwinArgs =
        com.pulumi.azurenative.digitaltwins.DigitalTwinArgs.builder()
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .privateEndpointConnections(
                privateEndpointConnections?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DigitalTwinArgs].
 */
@PulumiTagMarker
public class DigitalTwinArgsBuilder internal constructor() {
    private var identity: Output<DigitalTwinsIdentityArgs>? = null

    private var location: Output<String>? = null

    private var privateEndpointConnections: Output<List<PrivateEndpointConnectionArgs>>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The managed identity for the DigitalTwinsInstance.
     */
    @JvmName("elgrfgustgoqaaoa")
    public suspend fun identity(`value`: Output<DigitalTwinsIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The resource location.
     */
    @JvmName("djjwystkvgoirvvu")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The private endpoint connections.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("ckgwcjkqxfwfvgqe")
    public suspend
    fun privateEndpointConnections(`value`: Output<List<PrivateEndpointConnectionArgs>>) {
        this.privateEndpointConnections = value
    }

    @JvmName("irbvivxmdocnytri")
    public suspend fun privateEndpointConnections(
        vararg
        values: Output<PrivateEndpointConnectionArgs>,
    ) {
        this.privateEndpointConnections = Output.all(values.asList())
    }

    /**
     * @param values The private endpoint connections.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("famoofyrekyndclh")
    public suspend
    fun privateEndpointConnections(values: List<Output<PrivateEndpointConnectionArgs>>) {
        this.privateEndpointConnections = Output.all(values)
    }

    /**
     * @param value Public network access for the DigitalTwinsInstance.
     */
    @JvmName("sooqkerbewfntdgj")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccess>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value The name of the resource group that contains the DigitalTwinsInstance.
     */
    @JvmName("ueylqnbrclaoufiu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the DigitalTwinsInstance.
     */
    @JvmName("eqpmtmjwymyekfst")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("aefarqpjdknqbhjd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The managed identity for the DigitalTwinsInstance.
     */
    @JvmName("cxpvjtwodlcjyite")
    public suspend fun identity(`value`: DigitalTwinsIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The managed identity for the DigitalTwinsInstance.
     */
    @JvmName("gufmdtiouudtgigc")
    public suspend fun identity(argument: suspend DigitalTwinsIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = DigitalTwinsIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The resource location.
     */
    @JvmName("mwxcndgluwfevdai")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The private endpoint connections.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("rilnijtmbjqjmfaq")
    public suspend fun privateEndpointConnections(`value`: List<PrivateEndpointConnectionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnections = mapped
    }

    /**
     * @param argument The private endpoint connections.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("gmkgiyidjpqyxkmv")
    public suspend
    fun privateEndpointConnections(argument: List<suspend PrivateEndpointConnectionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PrivateEndpointConnectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.privateEndpointConnections = mapped
    }

    /**
     * @param argument The private endpoint connections.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("jtmsqosypyijqprp")
    public suspend fun privateEndpointConnections(
        vararg
        argument: suspend PrivateEndpointConnectionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PrivateEndpointConnectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.privateEndpointConnections = mapped
    }

    /**
     * @param argument The private endpoint connections.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("pckkwbbgskjvkmyx")
    public suspend
    fun privateEndpointConnections(argument: suspend PrivateEndpointConnectionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PrivateEndpointConnectionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.privateEndpointConnections = mapped
    }

    /**
     * @param values The private endpoint connections.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("pqboxdxqxwxoapnh")
    public suspend fun privateEndpointConnections(vararg values: PrivateEndpointConnectionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateEndpointConnections = mapped
    }

    /**
     * @param value Public network access for the DigitalTwinsInstance.
     */
    @JvmName("pdooauejlhcymtrd")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Public network access for the DigitalTwinsInstance.
     */
    @JvmName("vdmmovgywnymghfj")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Public network access for the DigitalTwinsInstance.
     */
    @JvmName("nvluorhcdlldxehe")
    public fun publicNetworkAccess(`value`: PublicNetworkAccess) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value The name of the resource group that contains the DigitalTwinsInstance.
     */
    @JvmName("uxbglghkhmavlyxs")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the DigitalTwinsInstance.
     */
    @JvmName("hwadplgdlqeciprb")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("yttgyxllctcjndqj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The resource tags.
     */
    @JvmName("fisuuhatirjtfort")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DigitalTwinArgs = DigitalTwinArgs(
        identity = identity,
        location = location,
        privateEndpointConnections = privateEndpointConnections,
        publicNetworkAccess = publicNetworkAccess,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        tags = tags,
    )
}
