@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.digitaltwins.kotlin

import com.pulumi.azurenative.digitaltwins.DigitalTwinsEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * DigitalTwinsInstance endpoint resource.
 * Azure REST API version: 2023-01-31. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-03-01-preview.
 * ## Example Usage
 * ### Put a DigitalTwinsEndpoint resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var digitalTwinsEndpoint = new AzureNative.DigitalTwins.DigitalTwinsEndpoint("digitalTwinsEndpoint", new()
 *     {
 *         EndpointName = "myServiceBus",
 *         Properties = new AzureNative.DigitalTwins.Inputs.ServiceBusArgs
 *         {
 *             AuthenticationType = "KeyBased",
 *             EndpointType = "ServiceBus",
 *             PrimaryConnectionString = "Endpoint=sb://mysb.servicebus.windows.net/;SharedAccessKeyName=RootManageSharedAccessKey;SharedAccessKey=xyzxyzoX4=;EntityPath=abcabc",
 *             SecondaryConnectionString = "Endpoint=sb://mysb.servicebus.windows.net/;SharedAccessKeyName=RootManageSharedAccessKey;SharedAccessKey=xyzxyzoX4=;EntityPath=abcabc",
 *         },
 *         ResourceGroupName = "resRg",
 *         ResourceName = "myDigitalTwinsService",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/digitaltwins/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := digitaltwins.NewDigitalTwinsEndpoint(ctx, "digitalTwinsEndpoint", &digitaltwins.DigitalTwinsEndpointArgs{
 * 			EndpointName: pulumi.String("myServiceBus"),
 * 			Properties: digitaltwins.ServiceBus{
 * 				AuthenticationType:        "KeyBased",
 * 				EndpointType:              "ServiceBus",
 * 				PrimaryConnectionString:   "Endpoint=sb://mysb.servicebus.windows.net/;SharedAccessKeyName=RootManageSharedAccessKey;SharedAccessKey=xyzxyzoX4=;EntityPath=abcabc",
 * 				SecondaryConnectionString: "Endpoint=sb://mysb.servicebus.windows.net/;SharedAccessKeyName=RootManageSharedAccessKey;SharedAccessKey=xyzxyzoX4=;EntityPath=abcabc",
 * 			},
 * 			ResourceGroupName: pulumi.String("resRg"),
 * 			ResourceName:      pulumi.String("myDigitalTwinsService"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.digitaltwins.DigitalTwinsEndpoint;
 * import com.pulumi.azurenative.digitaltwins.DigitalTwinsEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var digitalTwinsEndpoint = new DigitalTwinsEndpoint("digitalTwinsEndpoint", DigitalTwinsEndpointArgs.builder()
 *             .endpointName("myServiceBus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("authenticationType", "KeyBased"),
 *                 Map.entry("endpointType", "ServiceBus"),
 *                 Map.entry("primaryConnectionString", "Endpoint=sb://mysb.servicebus.windows.net/;SharedAccessKeyName=RootManageSharedAccessKey;SharedAccessKey=xyzxyzoX4=;EntityPath=abcabc"),
 *                 Map.entry("secondaryConnectionString", "Endpoint=sb://mysb.servicebus.windows.net/;SharedAccessKeyName=RootManageSharedAccessKey;SharedAccessKey=xyzxyzoX4=;EntityPath=abcabc")
 *             ))
 *             .resourceGroupName("resRg")
 *             .resourceName("myDigitalTwinsService")
 *             .build());
 *     }
 * }
 * ```
 * ### Put a DigitalTwinsEndpoint resource with identity
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var digitalTwinsEndpoint = new AzureNative.DigitalTwins.DigitalTwinsEndpoint("digitalTwinsEndpoint", new()
 *     {
 *         EndpointName = "myServiceBus",
 *         Properties = new AzureNative.DigitalTwins.Inputs.ServiceBusArgs
 *         {
 *             AuthenticationType = "IdentityBased",
 *             EndpointType = "ServiceBus",
 *             EndpointUri = "sb://mysb.servicebus.windows.net/",
 *             EntityPath = "mysbtopic",
 *         },
 *         ResourceGroupName = "resRg",
 *         ResourceName = "myDigitalTwinsService",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/digitaltwins/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := digitaltwins.NewDigitalTwinsEndpoint(ctx, "digitalTwinsEndpoint", &digitaltwins.DigitalTwinsEndpointArgs{
 * 			EndpointName: pulumi.String("myServiceBus"),
 * 			Properties: digitaltwins.ServiceBus{
 * 				AuthenticationType: "IdentityBased",
 * 				EndpointType:       "ServiceBus",
 * 				EndpointUri:        "sb://mysb.servicebus.windows.net/",
 * 				EntityPath:         "mysbtopic",
 * 			},
 * 			ResourceGroupName: pulumi.String("resRg"),
 * 			ResourceName:      pulumi.String("myDigitalTwinsService"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.digitaltwins.DigitalTwinsEndpoint;
 * import com.pulumi.azurenative.digitaltwins.DigitalTwinsEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var digitalTwinsEndpoint = new DigitalTwinsEndpoint("digitalTwinsEndpoint", DigitalTwinsEndpointArgs.builder()
 *             .endpointName("myServiceBus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("authenticationType", "IdentityBased"),
 *                 Map.entry("endpointType", "ServiceBus"),
 *                 Map.entry("endpointUri", "sb://mysb.servicebus.windows.net/"),
 *                 Map.entry("entityPath", "mysbtopic")
 *             ))
 *             .resourceGroupName("resRg")
 *             .resourceName("myDigitalTwinsService")
 *             .build());
 *     }
 * }
 * ```
 * ### Put a DigitalTwinsEndpoint resource with user assigned identity
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var digitalTwinsEndpoint = new AzureNative.DigitalTwins.DigitalTwinsEndpoint("digitalTwinsEndpoint", new()
 *     {
 *         EndpointName = "myServiceBus",
 *         Properties = new AzureNative.DigitalTwins.Inputs.ServiceBusArgs
 *         {
 *             AuthenticationType = "IdentityBased",
 *             EndpointType = "ServiceBus",
 *             EndpointUri = "sb://mysb.servicebus.windows.net/",
 *             EntityPath = "mysbtopic",
 *             Identity = new AzureNative.DigitalTwins.Inputs.ManagedIdentityReferenceArgs
 *             {
 *                 Type = "UserAssigned",
 *                 UserAssignedIdentity = "/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourceGroups/testrg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testidentity",
 *             },
 *         },
 *         ResourceGroupName = "resRg",
 *         ResourceName = "myDigitalTwinsService",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/digitaltwins/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := digitaltwins.NewDigitalTwinsEndpoint(ctx, "digitalTwinsEndpoint", &digitaltwins.DigitalTwinsEndpointArgs{
 * 			EndpointName: pulumi.String("myServiceBus"),
 * 			Properties: digitaltwins.ServiceBus{
 * 				AuthenticationType: "IdentityBased",
 * 				EndpointType:       "ServiceBus",
 * 				EndpointUri:        "sb://mysb.servicebus.windows.net/",
 * 				EntityPath:         "mysbtopic",
 * 				Identity: digitaltwins.ManagedIdentityReference{
 * 					Type:                 "UserAssigned",
 * 					UserAssignedIdentity: "/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourceGroups/testrg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testidentity",
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("resRg"),
 * 			ResourceName:      pulumi.String("myDigitalTwinsService"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.digitaltwins.DigitalTwinsEndpoint;
 * import com.pulumi.azurenative.digitaltwins.DigitalTwinsEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var digitalTwinsEndpoint = new DigitalTwinsEndpoint("digitalTwinsEndpoint", DigitalTwinsEndpointArgs.builder()
 *             .endpointName("myServiceBus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("authenticationType", "IdentityBased"),
 *                 Map.entry("endpointType", "ServiceBus"),
 *                 Map.entry("endpointUri", "sb://mysb.servicebus.windows.net/"),
 *                 Map.entry("entityPath", "mysbtopic"),
 *                 Map.entry("identity", Map.ofEntries(
 *                     Map.entry("type", "UserAssigned"),
 *                     Map.entry("userAssignedIdentity", "/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourceGroups/testrg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testidentity")
 *                 ))
 *             ))
 *             .resourceGroupName("resRg")
 *             .resourceName("myDigitalTwinsService")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:digitaltwins:DigitalTwinsEndpoint myServiceBus /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DigitalTwins/digitalTwinsInstances/{resourceName}/endpoints/{endpointName}
 * ```
 * @property endpointName Name of Endpoint Resource.
 * @property properties DigitalTwinsInstance endpoint resource properties.
 * @property resourceGroupName The name of the resource group that contains the DigitalTwinsInstance.
 * @property resourceName The name of the DigitalTwinsInstance.
 */
public data class DigitalTwinsEndpointArgs(
    public val endpointName: Output<String>? = null,
    public val properties: Output<Any>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.digitaltwins.DigitalTwinsEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.digitaltwins.DigitalTwinsEndpointArgs =
        com.pulumi.azurenative.digitaltwins.DigitalTwinsEndpointArgs.builder()
            .endpointName(endpointName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DigitalTwinsEndpointArgs].
 */
@PulumiTagMarker
public class DigitalTwinsEndpointArgsBuilder internal constructor() {
    private var endpointName: Output<String>? = null

    private var properties: Output<Any>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    /**
     * @param value Name of Endpoint Resource.
     */
    @JvmName("owendfxebvivgrul")
    public suspend fun endpointName(`value`: Output<String>) {
        this.endpointName = value
    }

    /**
     * @param value DigitalTwinsInstance endpoint resource properties.
     */
    @JvmName("csswcbducoxenpbr")
    public suspend fun properties(`value`: Output<Any>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group that contains the DigitalTwinsInstance.
     */
    @JvmName("byljbsejiuqhbstp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the DigitalTwinsInstance.
     */
    @JvmName("rkpaimgvlqxnaixr")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Name of Endpoint Resource.
     */
    @JvmName("dbsvxsmtjqlfkvdw")
    public suspend fun endpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointName = mapped
    }

    /**
     * @param value DigitalTwinsInstance endpoint resource properties.
     */
    @JvmName("bhfebmvkftbwcpry")
    public suspend fun properties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group that contains the DigitalTwinsInstance.
     */
    @JvmName("kxdaxpskojkecuuj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the DigitalTwinsInstance.
     */
    @JvmName("bctaammqojousjre")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    internal fun build(): DigitalTwinsEndpointArgs = DigitalTwinsEndpointArgs(
        endpointName = endpointName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
    )
}
