@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.digitaltwins.kotlin.inputs

import com.pulumi.azurenative.digitaltwins.inputs.EventGridArgs.builder
import com.pulumi.azurenative.digitaltwins.kotlin.enums.AuthenticationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Properties related to EventGrid.
 * @property accessKey1 EventGrid secondary accesskey. Will be obfuscated during read.
 * @property accessKey2 EventGrid secondary accesskey. Will be obfuscated during read.
 * @property authenticationType Specifies the authentication type being used for connecting to the endpoint. Defaults to 'KeyBased'. If 'KeyBased' is selected, a connection string must be specified (at least the primary connection string). If 'IdentityBased' is select, the endpointUri and entityPath properties must be specified.
 * @property deadLetterSecret Dead letter storage secret for key-based authentication. Will be obfuscated during read.
 * @property deadLetterUri Dead letter storage URL for identity-based authentication.
 * @property endpointType The type of Digital Twins endpoint
 * Expected value is 'EventGrid'.
 * @property identity Managed identity properties for the endpoint.
 * @property topicEndpoint EventGrid Topic Endpoint.
 */
public data class EventGridArgs(
    public val accessKey1: Output<String>,
    public val accessKey2: Output<String>? = null,
    public val authenticationType: Output<Either<String, AuthenticationType>>? = null,
    public val deadLetterSecret: Output<String>? = null,
    public val deadLetterUri: Output<String>? = null,
    public val endpointType: Output<String>,
    public val identity: Output<ManagedIdentityReferenceArgs>? = null,
    public val topicEndpoint: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.digitaltwins.inputs.EventGridArgs> {
    override fun toJava(): com.pulumi.azurenative.digitaltwins.inputs.EventGridArgs =
        com.pulumi.azurenative.digitaltwins.inputs.EventGridArgs.builder()
            .accessKey1(accessKey1.applyValue({ args0 -> args0 }))
            .accessKey2(accessKey2?.applyValue({ args0 -> args0 }))
            .authenticationType(
                authenticationType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .deadLetterSecret(deadLetterSecret?.applyValue({ args0 -> args0 }))
            .deadLetterUri(deadLetterUri?.applyValue({ args0 -> args0 }))
            .endpointType(endpointType.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .topicEndpoint(topicEndpoint.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventGridArgs].
 */
@PulumiTagMarker
public class EventGridArgsBuilder internal constructor() {
    private var accessKey1: Output<String>? = null

    private var accessKey2: Output<String>? = null

    private var authenticationType: Output<Either<String, AuthenticationType>>? = null

    private var deadLetterSecret: Output<String>? = null

    private var deadLetterUri: Output<String>? = null

    private var endpointType: Output<String>? = null

    private var identity: Output<ManagedIdentityReferenceArgs>? = null

    private var topicEndpoint: Output<String>? = null

    /**
     * @param value EventGrid secondary accesskey. Will be obfuscated during read.
     */
    @JvmName("xxixufwmuvgesnka")
    public suspend fun accessKey1(`value`: Output<String>) {
        this.accessKey1 = value
    }

    /**
     * @param value EventGrid secondary accesskey. Will be obfuscated during read.
     */
    @JvmName("qabyjusydljgltma")
    public suspend fun accessKey2(`value`: Output<String>) {
        this.accessKey2 = value
    }

    /**
     * @param value Specifies the authentication type being used for connecting to the endpoint. Defaults to 'KeyBased'. If 'KeyBased' is selected, a connection string must be specified (at least the primary connection string). If 'IdentityBased' is select, the endpointUri and entityPath properties must be specified.
     */
    @JvmName("vsqmqejuwqggqqhh")
    public suspend fun authenticationType(`value`: Output<Either<String, AuthenticationType>>) {
        this.authenticationType = value
    }

    /**
     * @param value Dead letter storage secret for key-based authentication. Will be obfuscated during read.
     */
    @JvmName("itdkunrulnrfdoyk")
    public suspend fun deadLetterSecret(`value`: Output<String>) {
        this.deadLetterSecret = value
    }

    /**
     * @param value Dead letter storage URL for identity-based authentication.
     */
    @JvmName("jlknfdjdbmkhgnvq")
    public suspend fun deadLetterUri(`value`: Output<String>) {
        this.deadLetterUri = value
    }

    /**
     * @param value The type of Digital Twins endpoint
     * Expected value is 'EventGrid'.
     */
    @JvmName("uswuvtffexlnerwe")
    public suspend fun endpointType(`value`: Output<String>) {
        this.endpointType = value
    }

    /**
     * @param value Managed identity properties for the endpoint.
     */
    @JvmName("orqgcviecehhgwjf")
    public suspend fun identity(`value`: Output<ManagedIdentityReferenceArgs>) {
        this.identity = value
    }

    /**
     * @param value EventGrid Topic Endpoint.
     */
    @JvmName("wldhsodpqbgxuidq")
    public suspend fun topicEndpoint(`value`: Output<String>) {
        this.topicEndpoint = value
    }

    /**
     * @param value EventGrid secondary accesskey. Will be obfuscated during read.
     */
    @JvmName("eoeiacsguoxpuvkf")
    public suspend fun accessKey1(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessKey1 = mapped
    }

    /**
     * @param value EventGrid secondary accesskey. Will be obfuscated during read.
     */
    @JvmName("hmqwgxavmassfkfa")
    public suspend fun accessKey2(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessKey2 = mapped
    }

    /**
     * @param value Specifies the authentication type being used for connecting to the endpoint. Defaults to 'KeyBased'. If 'KeyBased' is selected, a connection string must be specified (at least the primary connection string). If 'IdentityBased' is select, the endpointUri and entityPath properties must be specified.
     */
    @JvmName("lmcmnxfgqavhjcrp")
    public suspend fun authenticationType(`value`: Either<String, AuthenticationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value Specifies the authentication type being used for connecting to the endpoint. Defaults to 'KeyBased'. If 'KeyBased' is selected, a connection string must be specified (at least the primary connection string). If 'IdentityBased' is select, the endpointUri and entityPath properties must be specified.
     */
    @JvmName("prwvokbmtdqwyqfj")
    public fun authenticationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value Specifies the authentication type being used for connecting to the endpoint. Defaults to 'KeyBased'. If 'KeyBased' is selected, a connection string must be specified (at least the primary connection string). If 'IdentityBased' is select, the endpointUri and entityPath properties must be specified.
     */
    @JvmName("ddscfinvjhjntpfm")
    public fun authenticationType(`value`: AuthenticationType) {
        val toBeMapped = Either.ofRight<String, AuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value Dead letter storage secret for key-based authentication. Will be obfuscated during read.
     */
    @JvmName("nlxtdethgladdfwp")
    public suspend fun deadLetterSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deadLetterSecret = mapped
    }

    /**
     * @param value Dead letter storage URL for identity-based authentication.
     */
    @JvmName("aguqbecvwuiqhhrb")
    public suspend fun deadLetterUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deadLetterUri = mapped
    }

    /**
     * @param value The type of Digital Twins endpoint
     * Expected value is 'EventGrid'.
     */
    @JvmName("tukgkedtqfmbgeqx")
    public suspend fun endpointType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointType = mapped
    }

    /**
     * @param value Managed identity properties for the endpoint.
     */
    @JvmName("kbvfaiqconhecagb")
    public suspend fun identity(`value`: ManagedIdentityReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Managed identity properties for the endpoint.
     */
    @JvmName("jqolbygavbxoowtp")
    public suspend fun identity(argument: suspend ManagedIdentityReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedIdentityReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value EventGrid Topic Endpoint.
     */
    @JvmName("khbaneudbfsrkyso")
    public suspend fun topicEndpoint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.topicEndpoint = mapped
    }

    internal fun build(): EventGridArgs = EventGridArgs(
        accessKey1 = accessKey1 ?: throw PulumiNullFieldException("accessKey1"),
        accessKey2 = accessKey2,
        authenticationType = authenticationType,
        deadLetterSecret = deadLetterSecret,
        deadLetterUri = deadLetterUri,
        endpointType = endpointType ?: throw PulumiNullFieldException("endpointType"),
        identity = identity,
        topicEndpoint = topicEndpoint ?: throw PulumiNullFieldException("topicEndpoint"),
    )
}
