@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.digitaltwins.kotlin.inputs

import com.pulumi.azurenative.digitaltwins.inputs.GetTimeSeriesDatabaseConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group that contains the DigitalTwinsInstance.
 * @property resourceName The name of the DigitalTwinsInstance.
 * @property timeSeriesDatabaseConnectionName Name of time series database connection.
 */
public data class GetTimeSeriesDatabaseConnectionPlainArgs(
    public val resourceGroupName: String,
    public val resourceName: String,
    public val timeSeriesDatabaseConnectionName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.digitaltwins.inputs.GetTimeSeriesDatabaseConnectionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.digitaltwins.inputs.GetTimeSeriesDatabaseConnectionPlainArgs =
        com.pulumi.azurenative.digitaltwins.inputs.GetTimeSeriesDatabaseConnectionPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 }))
            .timeSeriesDatabaseConnectionName(timeSeriesDatabaseConnectionName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTimeSeriesDatabaseConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetTimeSeriesDatabaseConnectionPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    private var timeSeriesDatabaseConnectionName: String? = null

    /**
     * @param value The name of the resource group that contains the DigitalTwinsInstance.
     */
    @JvmName("knqyntgchgjqnark")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the DigitalTwinsInstance.
     */
    @JvmName("qmyxmkfgutqsqfiw")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    /**
     * @param value Name of time series database connection.
     */
    @JvmName("eyweyogsssbhcano")
    public suspend fun timeSeriesDatabaseConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.timeSeriesDatabaseConnectionName = mapped
    }

    internal fun build(): GetTimeSeriesDatabaseConnectionPlainArgs =
        GetTimeSeriesDatabaseConnectionPlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
            timeSeriesDatabaseConnectionName = timeSeriesDatabaseConnectionName ?: throw
                PulumiNullFieldException("timeSeriesDatabaseConnectionName"),
        )
}
