@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.digitaltwins.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties of a time series database connection to Azure Data Explorer with data being sent via an EventHub.
 * @property adxDatabaseName The name of the Azure Data Explorer database.
 * @property adxEndpointUri The URI of the Azure Data Explorer endpoint.
 * @property adxRelationshipLifecycleEventsTableName The name of the Azure Data Explorer table used for recording relationship lifecycle events. The table will not be created if this property is left unspecified.
 * @property adxResourceId The resource ID of the Azure Data Explorer cluster.
 * @property adxTableName The name of the Azure Data Explorer table used for storing updates to properties of twins and relationships. Defaults to AdtPropertyEvents.
 * @property adxTwinLifecycleEventsTableName The name of the Azure Data Explorer table used for recording twin lifecycle events. The table will not be created if this property is left unspecified.
 * @property connectionType The type of time series connection resource.
 * Expected value is 'AzureDataExplorer'.
 * @property eventHubConsumerGroup The EventHub consumer group to use when ADX reads from EventHub. Defaults to $Default.
 * @property eventHubEndpointUri The URL of the EventHub namespace for identity-based authentication. It must include the protocol sb://
 * @property eventHubEntityPath The EventHub name in the EventHub namespace for identity-based authentication.
 * @property eventHubNamespaceResourceId The resource ID of the EventHub namespace.
 * @property identity Managed identity properties for the time series database connection resource.
 * @property provisioningState The provisioning state.
 * @property recordPropertyAndItemRemovals Specifies whether or not to record twin / relationship property and item removals, including removals of indexed or keyed values (such as map entries, array elements, etc.). This feature is de-activated unless explicitly set to 'true'. Setting this property to 'true' will generate an additional column in the property events table in ADX.
 */
public data class AzureDataExplorerConnectionPropertiesResponse(
    public val adxDatabaseName: String,
    public val adxEndpointUri: String,
    public val adxRelationshipLifecycleEventsTableName: String? = null,
    public val adxResourceId: String,
    public val adxTableName: String? = null,
    public val adxTwinLifecycleEventsTableName: String? = null,
    public val connectionType: String,
    public val eventHubConsumerGroup: String? = null,
    public val eventHubEndpointUri: String,
    public val eventHubEntityPath: String,
    public val eventHubNamespaceResourceId: String,
    public val identity: ManagedIdentityReferenceResponse? = null,
    public val provisioningState: String,
    public val recordPropertyAndItemRemovals: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.digitaltwins.outputs.AzureDataExplorerConnectionPropertiesResponse):
            AzureDataExplorerConnectionPropertiesResponse =
            AzureDataExplorerConnectionPropertiesResponse(
                adxDatabaseName = javaType.adxDatabaseName(),
                adxEndpointUri = javaType.adxEndpointUri(),
                adxRelationshipLifecycleEventsTableName = javaType.adxRelationshipLifecycleEventsTableName().map({ args0 ->
                    args0
                }).orElse(null),
                adxResourceId = javaType.adxResourceId(),
                adxTableName = javaType.adxTableName().map({ args0 -> args0 }).orElse(null),
                adxTwinLifecycleEventsTableName = javaType.adxTwinLifecycleEventsTableName().map({ args0 ->
                    args0
                }).orElse(null),
                connectionType = javaType.connectionType(),
                eventHubConsumerGroup = javaType.eventHubConsumerGroup().map({ args0 -> args0 }).orElse(null),
                eventHubEndpointUri = javaType.eventHubEndpointUri(),
                eventHubEntityPath = javaType.eventHubEntityPath(),
                eventHubNamespaceResourceId = javaType.eventHubNamespaceResourceId(),
                identity = javaType.identity().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.digitaltwins.kotlin.outputs.ManagedIdentityReferenceResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                provisioningState = javaType.provisioningState(),
                recordPropertyAndItemRemovals = javaType.recordPropertyAndItemRemovals().map({ args0 ->
                    args0
                }).orElse(null),
            )
    }
}
