@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.digitaltwins.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The private endpoint connection of a Digital Twin.
 * @property id The resource identifier.
 * @property name The resource name.
 * @property properties The connection properties.
 * @property systemData Metadata pertaining to creation and last modification of the private endpoint connection.
 * @property type The resource type.
 */
public data class GetPrivateEndpointConnectionResult(
    public val id: String,
    public val name: String,
    public val properties: ConnectionPropertiesResponse,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.digitaltwins.outputs.GetPrivateEndpointConnectionResult):
            GetPrivateEndpointConnectionResult = GetPrivateEndpointConnectionResult(
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.digitaltwins.kotlin.outputs.ConnectionPropertiesResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.digitaltwins.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
