@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.digitaltwins.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties related to ServiceBus.
 * @property authenticationType Specifies the authentication type being used for connecting to the endpoint. Defaults to 'KeyBased'. If 'KeyBased' is selected, a connection string must be specified (at least the primary connection string). If 'IdentityBased' is select, the endpointUri and entityPath properties must be specified.
 * @property createdTime Time when the Endpoint was added to DigitalTwinsInstance.
 * @property deadLetterSecret Dead letter storage secret for key-based authentication. Will be obfuscated during read.
 * @property deadLetterUri Dead letter storage URL for identity-based authentication.
 * @property endpointType The type of Digital Twins endpoint
 * Expected value is 'ServiceBus'.
 * @property endpointUri The URL of the ServiceBus namespace for identity-based authentication. It must include the protocol 'sb://'.
 * @property entityPath The ServiceBus Topic name for identity-based authentication.
 * @property identity Managed identity properties for the endpoint.
 * @property primaryConnectionString PrimaryConnectionString of the endpoint for key-based authentication. Will be obfuscated during read.
 * @property provisioningState The provisioning state.
 * @property secondaryConnectionString SecondaryConnectionString of the endpoint for key-based authentication. Will be obfuscated during read.
 */
public data class ServiceBusResponse(
    public val authenticationType: String? = null,
    public val createdTime: String,
    public val deadLetterSecret: String? = null,
    public val deadLetterUri: String? = null,
    public val endpointType: String,
    public val endpointUri: String? = null,
    public val entityPath: String? = null,
    public val identity: ManagedIdentityReferenceResponse? = null,
    public val primaryConnectionString: String? = null,
    public val provisioningState: String,
    public val secondaryConnectionString: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.digitaltwins.outputs.ServiceBusResponse):
            ServiceBusResponse = ServiceBusResponse(
            authenticationType = javaType.authenticationType().map({ args0 -> args0 }).orElse(null),
            createdTime = javaType.createdTime(),
            deadLetterSecret = javaType.deadLetterSecret().map({ args0 -> args0 }).orElse(null),
            deadLetterUri = javaType.deadLetterUri().map({ args0 -> args0 }).orElse(null),
            endpointType = javaType.endpointType(),
            endpointUri = javaType.endpointUri().map({ args0 -> args0 }).orElse(null),
            entityPath = javaType.entityPath().map({ args0 -> args0 }).orElse(null),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.digitaltwins.kotlin.outputs.ManagedIdentityReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            primaryConnectionString = javaType.primaryConnectionString().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            secondaryConnectionString = javaType.secondaryConnectionString().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
