@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.azurenative.documentdb.kotlin.outputs.CassandraTableGetPropertiesResponseOptions
import com.pulumi.azurenative.documentdb.kotlin.outputs.CassandraTableGetPropertiesResponseResource
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.documentdb.kotlin.outputs.CassandraTableGetPropertiesResponseOptions.Companion.toKotlin as cassandraTableGetPropertiesResponseOptionsToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.CassandraTableGetPropertiesResponseResource.Companion.toKotlin as cassandraTableGetPropertiesResponseResourceToKotlin

/**
 * Builder for [CassandraResourceCassandraTable].
 */
@PulumiTagMarker
public class CassandraResourceCassandraTableResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CassandraResourceCassandraTableArgs = CassandraResourceCassandraTableArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CassandraResourceCassandraTableArgsBuilder.() -> Unit) {
        val builder = CassandraResourceCassandraTableArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CassandraResourceCassandraTable {
        val builtJavaResource =
            com.pulumi.azurenative.documentdb.CassandraResourceCassandraTable(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CassandraResourceCassandraTable(builtJavaResource)
    }
}

/**
 * An Azure Cosmos DB Cassandra table.
 * Azure REST API version: 2023-04-15. Prior API version in Azure Native 1.x: 2021-03-15.
 * Other available API versions: 2019-08-01, 2023-03-15-preview, 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview.
 * ## Example Usage
 * ### CosmosDBCassandraTableCreateUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cassandraResourceCassandraTable = new AzureNative.DocumentDB.CassandraResourceCassandraTable("cassandraResourceCassandraTable", new()
 *     {
 *         AccountName = "ddb1",
 *         KeyspaceName = "keyspaceName",
 *         Location = "West US",
 *         Options = null,
 *         Resource = new AzureNative.DocumentDB.Inputs.CassandraTableResourceArgs
 *         {
 *             DefaultTtl = 100,
 *             Id = "tableName",
 *             Schema = new AzureNative.DocumentDB.Inputs.CassandraSchemaArgs
 *             {
 *                 ClusterKeys = new[]
 *                 {
 *                     new AzureNative.DocumentDB.Inputs.ClusterKeyArgs
 *                     {
 *                         Name = "columnA",
 *                         OrderBy = "Asc",
 *                     },
 *                 },
 *                 Columns = new[]
 *                 {
 *                     new AzureNative.DocumentDB.Inputs.ColumnArgs
 *                     {
 *                         Name = "columnA",
 *                         Type = "Ascii",
 *                     },
 *                 },
 *                 PartitionKeys = new[]
 *                 {
 *                     new AzureNative.DocumentDB.Inputs.CassandraPartitionKeyArgs
 *                     {
 *                         Name = "columnA",
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         TableName = "tableName",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := documentdb.NewCassandraResourceCassandraTable(ctx, "cassandraResourceCassandraTable", &documentdb.CassandraResourceCassandraTableArgs{
 * AccountName: pulumi.String("ddb1"),
 * KeyspaceName: pulumi.String("keyspaceName"),
 * Location: pulumi.String("West US"),
 * Options: nil,
 * Resource: documentdb.CassandraTableGetPropertiesResponseResource{
 * DefaultTtl: pulumi.Int(100),
 * Id: pulumi.String("tableName"),
 * Schema: interface{}{
 * ClusterKeys: documentdb.ClusterKeyArray{
 * &documentdb.ClusterKeyArgs{
 * Name: pulumi.String("columnA"),
 * OrderBy: pulumi.String("Asc"),
 * },
 * },
 * Columns: documentdb.ColumnArray{
 * &documentdb.ColumnArgs{
 * Name: pulumi.String("columnA"),
 * Type: pulumi.String("Ascii"),
 * },
 * },
 * PartitionKeys: documentdb.CassandraPartitionKeyArray{
 * &documentdb.CassandraPartitionKeyArgs{
 * Name: pulumi.String("columnA"),
 * },
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * TableName: pulumi.String("tableName"),
 * Tags: nil,
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.CassandraResourceCassandraTable;
 * import com.pulumi.azurenative.documentdb.CassandraResourceCassandraTableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cassandraResourceCassandraTable = new CassandraResourceCassandraTable("cassandraResourceCassandraTable", CassandraResourceCassandraTableArgs.builder()
 *             .accountName("ddb1")
 *             .keyspaceName("keyspaceName")
 *             .location("West US")
 *             .options()
 *             .resource(Map.ofEntries(
 *                 Map.entry("defaultTtl", 100),
 *                 Map.entry("id", "tableName"),
 *                 Map.entry("schema", Map.ofEntries(
 *                     Map.entry("clusterKeys", Map.ofEntries(
 *                         Map.entry("name", "columnA"),
 *                         Map.entry("orderBy", "Asc")
 *                     )),
 *                     Map.entry("columns", Map.ofEntries(
 *                         Map.entry("name", "columnA"),
 *                         Map.entry("type", "Ascii")
 *                     )),
 *                     Map.entry("partitionKeys", Map.of("name", "columnA"))
 *                 ))
 *             ))
 *             .resourceGroupName("rg1")
 *             .tableName("tableName")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:CassandraResourceCassandraTable tableName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}/tables/{tableName}
 * ```
 */
public class CassandraResourceCassandraTable internal constructor(
    override val javaResource: com.pulumi.azurenative.documentdb.CassandraResourceCassandraTable,
) : KotlinCustomResource(javaResource, CassandraResourceCassandraTableMapper) {
    /**
     * The location of the resource group to which the resource belongs.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the ARM resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val options: Output<CassandraTableGetPropertiesResponseOptions>?
        get() = javaResource.options().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    cassandraTableGetPropertiesResponseOptionsToKotlin(args0)
                })
            }).orElse(null)
        })

    public val resource: Output<CassandraTableGetPropertiesResponseResource>?
        get() = javaResource.resource().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    cassandraTableGetPropertiesResponseResourceToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of Azure resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CassandraResourceCassandraTableMapper :
    ResourceMapper<CassandraResourceCassandraTable> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.documentdb.CassandraResourceCassandraTable::class == javaResource::class

    override fun map(javaResource: Resource): CassandraResourceCassandraTable =
        CassandraResourceCassandraTable(
            javaResource as
                com.pulumi.azurenative.documentdb.CassandraResourceCassandraTable,
        )
}

/**
 * @see [CassandraResourceCassandraTable].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CassandraResourceCassandraTable].
 */
public suspend fun cassandraResourceCassandraTable(
    name: String,
    block: suspend CassandraResourceCassandraTableResourceBuilder.() -> Unit,
):
    CassandraResourceCassandraTable {
    val builder = CassandraResourceCassandraTableResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CassandraResourceCassandraTable].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cassandraResourceCassandraTable(name: String): CassandraResourceCassandraTable {
    val builder = CassandraResourceCassandraTableResourceBuilder()
    builder.name(name)
    return builder.build()
}
