@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.azurenative.documentdb.DocumentdbFunctions.getCassandraClusterPlain
import com.pulumi.azurenative.documentdb.DocumentdbFunctions.getCassandraDataCenterPlain
import com.pulumi.azurenative.documentdb.DocumentdbFunctions.getCassandraResourceCassandraKeyspacePlain
import com.pulumi.azurenative.documentdb.DocumentdbFunctions.getCassandraResourceCassandraTablePlain
import com.pulumi.azurenative.documentdb.DocumentdbFunctions.getCassandraResourceCassandraViewPlain
import com.pulumi.azurenative.documentdb.DocumentdbFunctions.getDatabaseAccountPlain
import com.pulumi.azurenative.documentdb.DocumentdbFunctions.getGraphResourceGraphPlain
import com.pulumi.azurenative.documentdb.DocumentdbFunctions.getGremlinResourceGremlinDatabasePlain
import com.pulumi.azurenative.documentdb.DocumentdbFunctions.getGremlinResourceGremlinGraphPlain
import com.pulumi.azurenative.documentdb.DocumentdbFunctions.getMongoClusterFirewallRulePlain
import com.pulumi.azurenative.documentdb.DocumentdbFunctions.getMongoClusterPlain
import com.pulumi.azurenative.documentdb.DocumentdbFunctions.getMongoDBResourceMongoDBCollectionPlain
import com.pulumi.azurenative.documentdb.DocumentdbFunctions.getMongoDBResourceMongoDBDatabasePlain
import com.pulumi.azurenative.documentdb.DocumentdbFunctions.getMongoDBResourceMongoRoleDefinitionPlain
import com.pulumi.azurenative.documentdb.DocumentdbFunctions.getMongoDBResourceMongoUserDefinitionPlain
import com.pulumi.azurenative.documentdb.DocumentdbFunctions.getNotebookWorkspacePlain
import com.pulumi.azurenative.documentdb.DocumentdbFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.documentdb.DocumentdbFunctions.getServicePlain
import com.pulumi.azurenative.documentdb.DocumentdbFunctions.getSqlResourceSqlContainerPlain
import com.pulumi.azurenative.documentdb.DocumentdbFunctions.getSqlResourceSqlDatabasePlain
import com.pulumi.azurenative.documentdb.DocumentdbFunctions.getSqlResourceSqlRoleAssignmentPlain
import com.pulumi.azurenative.documentdb.DocumentdbFunctions.getSqlResourceSqlRoleDefinitionPlain
import com.pulumi.azurenative.documentdb.DocumentdbFunctions.getSqlResourceSqlStoredProcedurePlain
import com.pulumi.azurenative.documentdb.DocumentdbFunctions.getSqlResourceSqlTriggerPlain
import com.pulumi.azurenative.documentdb.DocumentdbFunctions.getSqlResourceSqlUserDefinedFunctionPlain
import com.pulumi.azurenative.documentdb.DocumentdbFunctions.getTableResourceTablePlain
import com.pulumi.azurenative.documentdb.DocumentdbFunctions.getThroughputPoolAccountPlain
import com.pulumi.azurenative.documentdb.DocumentdbFunctions.getThroughputPoolPlain
import com.pulumi.azurenative.documentdb.DocumentdbFunctions.listDatabaseAccountConnectionStringsPlain
import com.pulumi.azurenative.documentdb.DocumentdbFunctions.listDatabaseAccountKeysPlain
import com.pulumi.azurenative.documentdb.DocumentdbFunctions.listMongoClusterConnectionStringsPlain
import com.pulumi.azurenative.documentdb.DocumentdbFunctions.listNotebookWorkspaceConnectionInfoPlain
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetCassandraClusterPlainArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetCassandraClusterPlainArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetCassandraDataCenterPlainArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetCassandraDataCenterPlainArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetCassandraResourceCassandraKeyspacePlainArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetCassandraResourceCassandraKeyspacePlainArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetCassandraResourceCassandraTablePlainArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetCassandraResourceCassandraTablePlainArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetCassandraResourceCassandraViewPlainArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetCassandraResourceCassandraViewPlainArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetDatabaseAccountPlainArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetDatabaseAccountPlainArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetGraphResourceGraphPlainArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetGraphResourceGraphPlainArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetGremlinResourceGremlinDatabasePlainArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetGremlinResourceGremlinDatabasePlainArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetGremlinResourceGremlinGraphPlainArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetGremlinResourceGremlinGraphPlainArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetMongoClusterFirewallRulePlainArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetMongoClusterFirewallRulePlainArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetMongoClusterPlainArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetMongoClusterPlainArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetMongoDBResourceMongoDBCollectionPlainArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetMongoDBResourceMongoDBCollectionPlainArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetMongoDBResourceMongoDBDatabasePlainArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetMongoDBResourceMongoDBDatabasePlainArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetMongoDBResourceMongoRoleDefinitionPlainArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetMongoDBResourceMongoRoleDefinitionPlainArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetMongoDBResourceMongoUserDefinitionPlainArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetMongoDBResourceMongoUserDefinitionPlainArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetNotebookWorkspacePlainArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetNotebookWorkspacePlainArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetServicePlainArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetServicePlainArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetSqlResourceSqlContainerPlainArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetSqlResourceSqlContainerPlainArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetSqlResourceSqlDatabasePlainArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetSqlResourceSqlDatabasePlainArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetSqlResourceSqlRoleAssignmentPlainArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetSqlResourceSqlRoleAssignmentPlainArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetSqlResourceSqlRoleDefinitionPlainArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetSqlResourceSqlRoleDefinitionPlainArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetSqlResourceSqlStoredProcedurePlainArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetSqlResourceSqlStoredProcedurePlainArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetSqlResourceSqlTriggerPlainArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetSqlResourceSqlTriggerPlainArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetSqlResourceSqlUserDefinedFunctionPlainArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetSqlResourceSqlUserDefinedFunctionPlainArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetTableResourceTablePlainArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetTableResourceTablePlainArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetThroughputPoolAccountPlainArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetThroughputPoolAccountPlainArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetThroughputPoolPlainArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.GetThroughputPoolPlainArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.ListDatabaseAccountConnectionStringsPlainArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.ListDatabaseAccountConnectionStringsPlainArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.ListDatabaseAccountKeysPlainArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.ListDatabaseAccountKeysPlainArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.ListMongoClusterConnectionStringsPlainArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.ListMongoClusterConnectionStringsPlainArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.ListNotebookWorkspaceConnectionInfoPlainArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.ListNotebookWorkspaceConnectionInfoPlainArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetCassandraClusterResult
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetCassandraDataCenterResult
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetCassandraResourceCassandraKeyspaceResult
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetCassandraResourceCassandraTableResult
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetCassandraResourceCassandraViewResult
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetDatabaseAccountResult
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetGraphResourceGraphResult
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetGremlinResourceGremlinDatabaseResult
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetGremlinResourceGremlinGraphResult
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetMongoClusterFirewallRuleResult
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetMongoClusterResult
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetMongoDBResourceMongoDBCollectionResult
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetMongoDBResourceMongoDBDatabaseResult
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetMongoDBResourceMongoRoleDefinitionResult
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetMongoDBResourceMongoUserDefinitionResult
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetNotebookWorkspaceResult
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetPrivateEndpointConnectionResult
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetServiceResult
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetSqlResourceSqlContainerResult
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetSqlResourceSqlDatabaseResult
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetSqlResourceSqlRoleAssignmentResult
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetSqlResourceSqlRoleDefinitionResult
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetSqlResourceSqlStoredProcedureResult
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetSqlResourceSqlTriggerResult
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetSqlResourceSqlUserDefinedFunctionResult
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetTableResourceTableResult
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetThroughputPoolAccountResult
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetThroughputPoolResult
import com.pulumi.azurenative.documentdb.kotlin.outputs.ListDatabaseAccountConnectionStringsResult
import com.pulumi.azurenative.documentdb.kotlin.outputs.ListDatabaseAccountKeysResult
import com.pulumi.azurenative.documentdb.kotlin.outputs.ListMongoClusterConnectionStringsResult
import com.pulumi.azurenative.documentdb.kotlin.outputs.ListNotebookWorkspaceConnectionInfoResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetCassandraClusterResult.Companion.toKotlin as getCassandraClusterResultToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetCassandraDataCenterResult.Companion.toKotlin as getCassandraDataCenterResultToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetCassandraResourceCassandraKeyspaceResult.Companion.toKotlin as getCassandraResourceCassandraKeyspaceResultToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetCassandraResourceCassandraTableResult.Companion.toKotlin as getCassandraResourceCassandraTableResultToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetCassandraResourceCassandraViewResult.Companion.toKotlin as getCassandraResourceCassandraViewResultToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetDatabaseAccountResult.Companion.toKotlin as getDatabaseAccountResultToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetGraphResourceGraphResult.Companion.toKotlin as getGraphResourceGraphResultToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetGremlinResourceGremlinDatabaseResult.Companion.toKotlin as getGremlinResourceGremlinDatabaseResultToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetGremlinResourceGremlinGraphResult.Companion.toKotlin as getGremlinResourceGremlinGraphResultToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetMongoClusterFirewallRuleResult.Companion.toKotlin as getMongoClusterFirewallRuleResultToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetMongoClusterResult.Companion.toKotlin as getMongoClusterResultToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetMongoDBResourceMongoDBCollectionResult.Companion.toKotlin as getMongoDBResourceMongoDBCollectionResultToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetMongoDBResourceMongoDBDatabaseResult.Companion.toKotlin as getMongoDBResourceMongoDBDatabaseResultToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetMongoDBResourceMongoRoleDefinitionResult.Companion.toKotlin as getMongoDBResourceMongoRoleDefinitionResultToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetMongoDBResourceMongoUserDefinitionResult.Companion.toKotlin as getMongoDBResourceMongoUserDefinitionResultToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetNotebookWorkspaceResult.Companion.toKotlin as getNotebookWorkspaceResultToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetServiceResult.Companion.toKotlin as getServiceResultToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetSqlResourceSqlContainerResult.Companion.toKotlin as getSqlResourceSqlContainerResultToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetSqlResourceSqlDatabaseResult.Companion.toKotlin as getSqlResourceSqlDatabaseResultToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetSqlResourceSqlRoleAssignmentResult.Companion.toKotlin as getSqlResourceSqlRoleAssignmentResultToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetSqlResourceSqlRoleDefinitionResult.Companion.toKotlin as getSqlResourceSqlRoleDefinitionResultToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetSqlResourceSqlStoredProcedureResult.Companion.toKotlin as getSqlResourceSqlStoredProcedureResultToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetSqlResourceSqlTriggerResult.Companion.toKotlin as getSqlResourceSqlTriggerResultToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetSqlResourceSqlUserDefinedFunctionResult.Companion.toKotlin as getSqlResourceSqlUserDefinedFunctionResultToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetTableResourceTableResult.Companion.toKotlin as getTableResourceTableResultToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetThroughputPoolAccountResult.Companion.toKotlin as getThroughputPoolAccountResultToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.GetThroughputPoolResult.Companion.toKotlin as getThroughputPoolResultToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.ListDatabaseAccountConnectionStringsResult.Companion.toKotlin as listDatabaseAccountConnectionStringsResultToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.ListDatabaseAccountKeysResult.Companion.toKotlin as listDatabaseAccountKeysResultToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.ListMongoClusterConnectionStringsResult.Companion.toKotlin as listMongoClusterConnectionStringsResultToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.ListNotebookWorkspaceConnectionInfoResult.Companion.toKotlin as listNotebookWorkspaceConnectionInfoResultToKotlin

public object DocumentdbFunctions {
    /**
     * Get the properties of a managed Cassandra cluster.
     * Azure REST API version: 2023-04-15.
     * Other available API versions: 2021-07-01-preview, 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview.
     * @param argument null
     * @return Representation of a managed Cassandra cluster.
     */
    public suspend fun getCassandraCluster(argument: GetCassandraClusterPlainArgs):
        GetCassandraClusterResult =
        getCassandraClusterResultToKotlin(getCassandraClusterPlain(argument.toJava()).await())

    /**
     * @see [getCassandraCluster].
     * @param clusterName Managed Cassandra cluster name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Representation of a managed Cassandra cluster.
     */
    public suspend fun getCassandraCluster(clusterName: String, resourceGroupName: String):
        GetCassandraClusterResult {
        val argument = GetCassandraClusterPlainArgs(
            clusterName = clusterName,
            resourceGroupName = resourceGroupName,
        )
        return getCassandraClusterResultToKotlin(getCassandraClusterPlain(argument.toJava()).await())
    }

    /**
     * @see [getCassandraCluster].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;documentdb&#46;kotlin&#46;inputs&#46;GetCassandraClusterPlainArgs].
     * @return Representation of a managed Cassandra cluster.
     */
    public suspend
    fun getCassandraCluster(argument: suspend GetCassandraClusterPlainArgsBuilder.() -> Unit):
        GetCassandraClusterResult {
        val builder = GetCassandraClusterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCassandraClusterResultToKotlin(getCassandraClusterPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the properties of a managed Cassandra data center.
     * Azure REST API version: 2023-04-15.
     * Other available API versions: 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview.
     * @param argument null
     * @return A managed Cassandra data center.
     */
    public suspend fun getCassandraDataCenter(argument: GetCassandraDataCenterPlainArgs):
        GetCassandraDataCenterResult =
        getCassandraDataCenterResultToKotlin(getCassandraDataCenterPlain(argument.toJava()).await())

    /**
     * @see [getCassandraDataCenter].
     * @param clusterName Managed Cassandra cluster name.
     * @param dataCenterName Data center name in a managed Cassandra cluster.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return A managed Cassandra data center.
     */
    public suspend fun getCassandraDataCenter(
        clusterName: String,
        dataCenterName: String,
        resourceGroupName: String,
    ): GetCassandraDataCenterResult {
        val argument = GetCassandraDataCenterPlainArgs(
            clusterName = clusterName,
            dataCenterName = dataCenterName,
            resourceGroupName = resourceGroupName,
        )
        return getCassandraDataCenterResultToKotlin(getCassandraDataCenterPlain(argument.toJava()).await())
    }

    /**
     * @see [getCassandraDataCenter].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;documentdb&#46;kotlin&#46;inputs&#46;GetCassandraDataCenterPlainArgs].
     * @return A managed Cassandra data center.
     */
    public suspend
    fun getCassandraDataCenter(argument: suspend GetCassandraDataCenterPlainArgsBuilder.() -> Unit):
        GetCassandraDataCenterResult {
        val builder = GetCassandraDataCenterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCassandraDataCenterResultToKotlin(getCassandraDataCenterPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the Cassandra keyspaces under an existing Azure Cosmos DB database account with the provided name.
     * Azure REST API version: 2023-04-15.
     * Other available API versions: 2019-08-01, 2023-03-15-preview, 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview.
     * @param argument null
     * @return An Azure Cosmos DB Cassandra keyspace.
     */
    public suspend
    fun getCassandraResourceCassandraKeyspace(argument: GetCassandraResourceCassandraKeyspacePlainArgs):
        GetCassandraResourceCassandraKeyspaceResult =
        getCassandraResourceCassandraKeyspaceResultToKotlin(getCassandraResourceCassandraKeyspacePlain(argument.toJava()).await())

    /**
     * @see [getCassandraResourceCassandraKeyspace].
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return An Azure Cosmos DB Cassandra keyspace.
     */
    public suspend fun getCassandraResourceCassandraKeyspace(
        accountName: String,
        keyspaceName: String,
        resourceGroupName: String,
    ): GetCassandraResourceCassandraKeyspaceResult {
        val argument = GetCassandraResourceCassandraKeyspacePlainArgs(
            accountName = accountName,
            keyspaceName = keyspaceName,
            resourceGroupName = resourceGroupName,
        )
        return getCassandraResourceCassandraKeyspaceResultToKotlin(getCassandraResourceCassandraKeyspacePlain(argument.toJava()).await())
    }

    /**
     * @see [getCassandraResourceCassandraKeyspace].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;documentdb&#46;kotlin&#46;inputs&#46;GetCassandraResourceCassandraKeyspacePlainArgs].
     * @return An Azure Cosmos DB Cassandra keyspace.
     */
    public suspend
    fun getCassandraResourceCassandraKeyspace(argument: suspend GetCassandraResourceCassandraKeyspacePlainArgsBuilder.() -> Unit):
        GetCassandraResourceCassandraKeyspaceResult {
        val builder = GetCassandraResourceCassandraKeyspacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCassandraResourceCassandraKeyspaceResultToKotlin(getCassandraResourceCassandraKeyspacePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the Cassandra table under an existing Azure Cosmos DB database account.
     * Azure REST API version: 2023-04-15.
     * Other available API versions: 2019-08-01, 2023-03-15-preview, 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview.
     * @param argument null
     * @return An Azure Cosmos DB Cassandra table.
     */
    public suspend
    fun getCassandraResourceCassandraTable(argument: GetCassandraResourceCassandraTablePlainArgs):
        GetCassandraResourceCassandraTableResult =
        getCassandraResourceCassandraTableResultToKotlin(getCassandraResourceCassandraTablePlain(argument.toJava()).await())

    /**
     * @see [getCassandraResourceCassandraTable].
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param tableName Cosmos DB table name.
     * @return An Azure Cosmos DB Cassandra table.
     */
    public suspend fun getCassandraResourceCassandraTable(
        accountName: String,
        keyspaceName: String,
        resourceGroupName: String,
        tableName: String,
    ): GetCassandraResourceCassandraTableResult {
        val argument = GetCassandraResourceCassandraTablePlainArgs(
            accountName = accountName,
            keyspaceName = keyspaceName,
            resourceGroupName = resourceGroupName,
            tableName = tableName,
        )
        return getCassandraResourceCassandraTableResultToKotlin(getCassandraResourceCassandraTablePlain(argument.toJava()).await())
    }

    /**
     * @see [getCassandraResourceCassandraTable].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;documentdb&#46;kotlin&#46;inputs&#46;GetCassandraResourceCassandraTablePlainArgs].
     * @return An Azure Cosmos DB Cassandra table.
     */
    public suspend
    fun getCassandraResourceCassandraTable(argument: suspend GetCassandraResourceCassandraTablePlainArgsBuilder.() -> Unit):
        GetCassandraResourceCassandraTableResult {
        val builder = GetCassandraResourceCassandraTablePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCassandraResourceCassandraTableResultToKotlin(getCassandraResourceCassandraTablePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the Cassandra view under an existing Azure Cosmos DB database account.
     * Azure REST API version: 2023-03-15-preview.
     * Other available API versions: 2023-09-15-preview, 2023-11-15-preview.
     * @param argument null
     * @return An Azure Cosmos DB Cassandra view.
     */
    public suspend
    fun getCassandraResourceCassandraView(argument: GetCassandraResourceCassandraViewPlainArgs):
        GetCassandraResourceCassandraViewResult =
        getCassandraResourceCassandraViewResultToKotlin(getCassandraResourceCassandraViewPlain(argument.toJava()).await())

    /**
     * @see [getCassandraResourceCassandraView].
     * @param accountName Cosmos DB database account name.
     * @param keyspaceName Cosmos DB keyspace name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param viewName Cosmos DB view name.
     * @return An Azure Cosmos DB Cassandra view.
     */
    public suspend fun getCassandraResourceCassandraView(
        accountName: String,
        keyspaceName: String,
        resourceGroupName: String,
        viewName: String,
    ): GetCassandraResourceCassandraViewResult {
        val argument = GetCassandraResourceCassandraViewPlainArgs(
            accountName = accountName,
            keyspaceName = keyspaceName,
            resourceGroupName = resourceGroupName,
            viewName = viewName,
        )
        return getCassandraResourceCassandraViewResultToKotlin(getCassandraResourceCassandraViewPlain(argument.toJava()).await())
    }

    /**
     * @see [getCassandraResourceCassandraView].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;documentdb&#46;kotlin&#46;inputs&#46;GetCassandraResourceCassandraViewPlainArgs].
     * @return An Azure Cosmos DB Cassandra view.
     */
    public suspend
    fun getCassandraResourceCassandraView(argument: suspend GetCassandraResourceCassandraViewPlainArgsBuilder.() -> Unit):
        GetCassandraResourceCassandraViewResult {
        val builder = GetCassandraResourceCassandraViewPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCassandraResourceCassandraViewResultToKotlin(getCassandraResourceCassandraViewPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves the properties of an existing Azure Cosmos DB database account.
     * Azure REST API version: 2023-04-15.
     * Other available API versions: 2020-03-01, 2020-06-01-preview, 2020-09-01, 2021-04-01-preview, 2023-03-15-preview, 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview.
     * @param argument null
     * @return An Azure Cosmos DB database account.
     */
    public suspend fun getDatabaseAccount(argument: GetDatabaseAccountPlainArgs):
        GetDatabaseAccountResult =
        getDatabaseAccountResultToKotlin(getDatabaseAccountPlain(argument.toJava()).await())

    /**
     * @see [getDatabaseAccount].
     * @param accountName Cosmos DB database account name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return An Azure Cosmos DB database account.
     */
    public suspend fun getDatabaseAccount(accountName: String, resourceGroupName: String):
        GetDatabaseAccountResult {
        val argument = GetDatabaseAccountPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
        )
        return getDatabaseAccountResultToKotlin(getDatabaseAccountPlain(argument.toJava()).await())
    }

    /**
     * @see [getDatabaseAccount].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;documentdb&#46;kotlin&#46;inputs&#46;GetDatabaseAccountPlainArgs].
     * @return An Azure Cosmos DB database account.
     */
    public suspend
    fun getDatabaseAccount(argument: suspend GetDatabaseAccountPlainArgsBuilder.() -> Unit):
        GetDatabaseAccountResult {
        val builder = GetDatabaseAccountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDatabaseAccountResultToKotlin(getDatabaseAccountPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the Graph resource under an existing Azure Cosmos DB database account with the provided name.
     * Azure REST API version: 2023-03-15-preview.
     * Other available API versions: 2023-09-15-preview, 2023-11-15-preview.
     * @param argument null
     * @return An Azure Cosmos DB Graph resource.
     */
    public suspend fun getGraphResourceGraph(argument: GetGraphResourceGraphPlainArgs):
        GetGraphResourceGraphResult =
        getGraphResourceGraphResultToKotlin(getGraphResourceGraphPlain(argument.toJava()).await())

    /**
     * @see [getGraphResourceGraph].
     * @param accountName Cosmos DB database account name.
     * @param graphName Cosmos DB graph resource name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return An Azure Cosmos DB Graph resource.
     */
    public suspend fun getGraphResourceGraph(
        accountName: String,
        graphName: String,
        resourceGroupName: String,
    ): GetGraphResourceGraphResult {
        val argument = GetGraphResourceGraphPlainArgs(
            accountName = accountName,
            graphName = graphName,
            resourceGroupName = resourceGroupName,
        )
        return getGraphResourceGraphResultToKotlin(getGraphResourceGraphPlain(argument.toJava()).await())
    }

    /**
     * @see [getGraphResourceGraph].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;documentdb&#46;kotlin&#46;inputs&#46;GetGraphResourceGraphPlainArgs].
     * @return An Azure Cosmos DB Graph resource.
     */
    public suspend
    fun getGraphResourceGraph(argument: suspend GetGraphResourceGraphPlainArgsBuilder.() -> Unit):
        GetGraphResourceGraphResult {
        val builder = GetGraphResourceGraphPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGraphResourceGraphResultToKotlin(getGraphResourceGraphPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the Gremlin databases under an existing Azure Cosmos DB database account with the provided name.
     * Azure REST API version: 2023-04-15.
     * Other available API versions: 2019-08-01, 2023-03-15-preview, 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview.
     * @param argument null
     * @return An Azure Cosmos DB Gremlin database.
     */
    public suspend
    fun getGremlinResourceGremlinDatabase(argument: GetGremlinResourceGremlinDatabasePlainArgs):
        GetGremlinResourceGremlinDatabaseResult =
        getGremlinResourceGremlinDatabaseResultToKotlin(getGremlinResourceGremlinDatabasePlain(argument.toJava()).await())

    /**
     * @see [getGremlinResourceGremlinDatabase].
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return An Azure Cosmos DB Gremlin database.
     */
    public suspend fun getGremlinResourceGremlinDatabase(
        accountName: String,
        databaseName: String,
        resourceGroupName: String,
    ): GetGremlinResourceGremlinDatabaseResult {
        val argument = GetGremlinResourceGremlinDatabasePlainArgs(
            accountName = accountName,
            databaseName = databaseName,
            resourceGroupName = resourceGroupName,
        )
        return getGremlinResourceGremlinDatabaseResultToKotlin(getGremlinResourceGremlinDatabasePlain(argument.toJava()).await())
    }

    /**
     * @see [getGremlinResourceGremlinDatabase].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;documentdb&#46;kotlin&#46;inputs&#46;GetGremlinResourceGremlinDatabasePlainArgs].
     * @return An Azure Cosmos DB Gremlin database.
     */
    public suspend
    fun getGremlinResourceGremlinDatabase(argument: suspend GetGremlinResourceGremlinDatabasePlainArgsBuilder.() -> Unit):
        GetGremlinResourceGremlinDatabaseResult {
        val builder = GetGremlinResourceGremlinDatabasePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGremlinResourceGremlinDatabaseResultToKotlin(getGremlinResourceGremlinDatabasePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the Gremlin graph under an existing Azure Cosmos DB database account.
     * Azure REST API version: 2023-04-15.
     * Other available API versions: 2019-08-01, 2023-03-15-preview, 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview.
     * @param argument null
     * @return An Azure Cosmos DB Gremlin graph.
     */
    public suspend
    fun getGremlinResourceGremlinGraph(argument: GetGremlinResourceGremlinGraphPlainArgs):
        GetGremlinResourceGremlinGraphResult =
        getGremlinResourceGremlinGraphResultToKotlin(getGremlinResourceGremlinGraphPlain(argument.toJava()).await())

    /**
     * @see [getGremlinResourceGremlinGraph].
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return An Azure Cosmos DB Gremlin graph.
     */
    public suspend fun getGremlinResourceGremlinGraph(
        accountName: String,
        databaseName: String,
        graphName: String,
        resourceGroupName: String,
    ): GetGremlinResourceGremlinGraphResult {
        val argument = GetGremlinResourceGremlinGraphPlainArgs(
            accountName = accountName,
            databaseName = databaseName,
            graphName = graphName,
            resourceGroupName = resourceGroupName,
        )
        return getGremlinResourceGremlinGraphResultToKotlin(getGremlinResourceGremlinGraphPlain(argument.toJava()).await())
    }

    /**
     * @see [getGremlinResourceGremlinGraph].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;documentdb&#46;kotlin&#46;inputs&#46;GetGremlinResourceGremlinGraphPlainArgs].
     * @return An Azure Cosmos DB Gremlin graph.
     */
    public suspend
    fun getGremlinResourceGremlinGraph(argument: suspend GetGremlinResourceGremlinGraphPlainArgsBuilder.() -> Unit):
        GetGremlinResourceGremlinGraphResult {
        val builder = GetGremlinResourceGremlinGraphPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGremlinResourceGremlinGraphResultToKotlin(getGremlinResourceGremlinGraphPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about a mongo cluster.
     * Azure REST API version: 2023-03-15-preview.
     * Other available API versions: 2023-09-15-preview, 2023-11-15-preview.
     * @param argument null
     * @return Represents a mongo cluster resource.
     */
    public suspend fun getMongoCluster(argument: GetMongoClusterPlainArgs): GetMongoClusterResult =
        getMongoClusterResultToKotlin(getMongoClusterPlain(argument.toJava()).await())

    /**
     * @see [getMongoCluster].
     * @param mongoClusterName The name of the mongo cluster.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Represents a mongo cluster resource.
     */
    public suspend fun getMongoCluster(mongoClusterName: String, resourceGroupName: String):
        GetMongoClusterResult {
        val argument = GetMongoClusterPlainArgs(
            mongoClusterName = mongoClusterName,
            resourceGroupName = resourceGroupName,
        )
        return getMongoClusterResultToKotlin(getMongoClusterPlain(argument.toJava()).await())
    }

    /**
     * @see [getMongoCluster].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;documentdb&#46;kotlin&#46;inputs&#46;GetMongoClusterPlainArgs].
     * @return Represents a mongo cluster resource.
     */
    public suspend fun getMongoCluster(argument: suspend GetMongoClusterPlainArgsBuilder.() -> Unit):
        GetMongoClusterResult {
        val builder = GetMongoClusterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMongoClusterResultToKotlin(getMongoClusterPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about a mongo cluster firewall rule.
     * Azure REST API version: 2023-03-15-preview.
     * Other available API versions: 2023-09-15-preview, 2023-11-15-preview.
     * @param argument null
     * @return Represents a mongo cluster firewall rule.
     */
    public suspend fun getMongoClusterFirewallRule(argument: GetMongoClusterFirewallRulePlainArgs):
        GetMongoClusterFirewallRuleResult =
        getMongoClusterFirewallRuleResultToKotlin(getMongoClusterFirewallRulePlain(argument.toJava()).await())

    /**
     * @see [getMongoClusterFirewallRule].
     * @param firewallRuleName The name of the mongo cluster firewall rule.
     * @param mongoClusterName The name of the mongo cluster.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Represents a mongo cluster firewall rule.
     */
    public suspend fun getMongoClusterFirewallRule(
        firewallRuleName: String,
        mongoClusterName: String,
        resourceGroupName: String,
    ): GetMongoClusterFirewallRuleResult {
        val argument = GetMongoClusterFirewallRulePlainArgs(
            firewallRuleName = firewallRuleName,
            mongoClusterName = mongoClusterName,
            resourceGroupName = resourceGroupName,
        )
        return getMongoClusterFirewallRuleResultToKotlin(getMongoClusterFirewallRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getMongoClusterFirewallRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;documentdb&#46;kotlin&#46;inputs&#46;GetMongoClusterFirewallRulePlainArgs].
     * @return Represents a mongo cluster firewall rule.
     */
    public suspend
    fun getMongoClusterFirewallRule(argument: suspend GetMongoClusterFirewallRulePlainArgsBuilder.() -> Unit):
        GetMongoClusterFirewallRuleResult {
        val builder = GetMongoClusterFirewallRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMongoClusterFirewallRuleResultToKotlin(getMongoClusterFirewallRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the MongoDB collection under an existing Azure Cosmos DB database account.
     * Azure REST API version: 2023-04-15.
     * Other available API versions: 2019-08-01, 2023-03-15-preview, 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview.
     * @param argument null
     * @return An Azure Cosmos DB MongoDB collection.
     */
    public suspend
    fun getMongoDBResourceMongoDBCollection(argument: GetMongoDBResourceMongoDBCollectionPlainArgs):
        GetMongoDBResourceMongoDBCollectionResult =
        getMongoDBResourceMongoDBCollectionResultToKotlin(getMongoDBResourceMongoDBCollectionPlain(argument.toJava()).await())

    /**
     * @see [getMongoDBResourceMongoDBCollection].
     * @param accountName Cosmos DB database account name.
     * @param collectionName Cosmos DB collection name.
     * @param databaseName Cosmos DB database name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return An Azure Cosmos DB MongoDB collection.
     */
    public suspend fun getMongoDBResourceMongoDBCollection(
        accountName: String,
        collectionName: String,
        databaseName: String,
        resourceGroupName: String,
    ): GetMongoDBResourceMongoDBCollectionResult {
        val argument = GetMongoDBResourceMongoDBCollectionPlainArgs(
            accountName = accountName,
            collectionName = collectionName,
            databaseName = databaseName,
            resourceGroupName = resourceGroupName,
        )
        return getMongoDBResourceMongoDBCollectionResultToKotlin(getMongoDBResourceMongoDBCollectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getMongoDBResourceMongoDBCollection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;documentdb&#46;kotlin&#46;inputs&#46;GetMongoDBResourceMongoDBCollectionPlainArgs].
     * @return An Azure Cosmos DB MongoDB collection.
     */
    public suspend
    fun getMongoDBResourceMongoDBCollection(argument: suspend GetMongoDBResourceMongoDBCollectionPlainArgsBuilder.() -> Unit):
        GetMongoDBResourceMongoDBCollectionResult {
        val builder = GetMongoDBResourceMongoDBCollectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMongoDBResourceMongoDBCollectionResultToKotlin(getMongoDBResourceMongoDBCollectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the MongoDB databases under an existing Azure Cosmos DB database account with the provided name.
     * Azure REST API version: 2023-04-15.
     * Other available API versions: 2019-08-01, 2023-03-15-preview, 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview.
     * @param argument null
     * @return An Azure Cosmos DB MongoDB database.
     */
    public suspend
    fun getMongoDBResourceMongoDBDatabase(argument: GetMongoDBResourceMongoDBDatabasePlainArgs):
        GetMongoDBResourceMongoDBDatabaseResult =
        getMongoDBResourceMongoDBDatabaseResultToKotlin(getMongoDBResourceMongoDBDatabasePlain(argument.toJava()).await())

    /**
     * @see [getMongoDBResourceMongoDBDatabase].
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return An Azure Cosmos DB MongoDB database.
     */
    public suspend fun getMongoDBResourceMongoDBDatabase(
        accountName: String,
        databaseName: String,
        resourceGroupName: String,
    ): GetMongoDBResourceMongoDBDatabaseResult {
        val argument = GetMongoDBResourceMongoDBDatabasePlainArgs(
            accountName = accountName,
            databaseName = databaseName,
            resourceGroupName = resourceGroupName,
        )
        return getMongoDBResourceMongoDBDatabaseResultToKotlin(getMongoDBResourceMongoDBDatabasePlain(argument.toJava()).await())
    }

    /**
     * @see [getMongoDBResourceMongoDBDatabase].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;documentdb&#46;kotlin&#46;inputs&#46;GetMongoDBResourceMongoDBDatabasePlainArgs].
     * @return An Azure Cosmos DB MongoDB database.
     */
    public suspend
    fun getMongoDBResourceMongoDBDatabase(argument: suspend GetMongoDBResourceMongoDBDatabasePlainArgsBuilder.() -> Unit):
        GetMongoDBResourceMongoDBDatabaseResult {
        val builder = GetMongoDBResourceMongoDBDatabasePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMongoDBResourceMongoDBDatabaseResultToKotlin(getMongoDBResourceMongoDBDatabasePlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves the properties of an existing Azure Cosmos DB Mongo Role Definition with the given Id.
     * Azure REST API version: 2023-04-15.
     * Other available API versions: 2023-03-01-preview, 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview.
     * @param argument null
     * @return An Azure Cosmos DB Mongo Role Definition.
     */
    public suspend
    fun getMongoDBResourceMongoRoleDefinition(argument: GetMongoDBResourceMongoRoleDefinitionPlainArgs):
        GetMongoDBResourceMongoRoleDefinitionResult =
        getMongoDBResourceMongoRoleDefinitionResultToKotlin(getMongoDBResourceMongoRoleDefinitionPlain(argument.toJava()).await())

    /**
     * @see [getMongoDBResourceMongoRoleDefinition].
     * @param accountName Cosmos DB database account name.
     * @param mongoRoleDefinitionId The ID for the Role Definition {dbName.roleName}.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return An Azure Cosmos DB Mongo Role Definition.
     */
    public suspend fun getMongoDBResourceMongoRoleDefinition(
        accountName: String,
        mongoRoleDefinitionId: String,
        resourceGroupName: String,
    ): GetMongoDBResourceMongoRoleDefinitionResult {
        val argument = GetMongoDBResourceMongoRoleDefinitionPlainArgs(
            accountName = accountName,
            mongoRoleDefinitionId = mongoRoleDefinitionId,
            resourceGroupName = resourceGroupName,
        )
        return getMongoDBResourceMongoRoleDefinitionResultToKotlin(getMongoDBResourceMongoRoleDefinitionPlain(argument.toJava()).await())
    }

    /**
     * @see [getMongoDBResourceMongoRoleDefinition].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;documentdb&#46;kotlin&#46;inputs&#46;GetMongoDBResourceMongoRoleDefinitionPlainArgs].
     * @return An Azure Cosmos DB Mongo Role Definition.
     */
    public suspend
    fun getMongoDBResourceMongoRoleDefinition(argument: suspend GetMongoDBResourceMongoRoleDefinitionPlainArgsBuilder.() -> Unit):
        GetMongoDBResourceMongoRoleDefinitionResult {
        val builder = GetMongoDBResourceMongoRoleDefinitionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMongoDBResourceMongoRoleDefinitionResultToKotlin(getMongoDBResourceMongoRoleDefinitionPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves the properties of an existing Azure Cosmos DB Mongo User Definition with the given Id.
     * Azure REST API version: 2023-04-15.
     * Other available API versions: 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview.
     * @param argument null
     * @return An Azure Cosmos DB User Definition
     */
    public suspend
    fun getMongoDBResourceMongoUserDefinition(argument: GetMongoDBResourceMongoUserDefinitionPlainArgs):
        GetMongoDBResourceMongoUserDefinitionResult =
        getMongoDBResourceMongoUserDefinitionResultToKotlin(getMongoDBResourceMongoUserDefinitionPlain(argument.toJava()).await())

    /**
     * @see [getMongoDBResourceMongoUserDefinition].
     * @param accountName Cosmos DB database account name.
     * @param mongoUserDefinitionId The ID for the User Definition {dbName.userName}.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return An Azure Cosmos DB User Definition
     */
    public suspend fun getMongoDBResourceMongoUserDefinition(
        accountName: String,
        mongoUserDefinitionId: String,
        resourceGroupName: String,
    ): GetMongoDBResourceMongoUserDefinitionResult {
        val argument = GetMongoDBResourceMongoUserDefinitionPlainArgs(
            accountName = accountName,
            mongoUserDefinitionId = mongoUserDefinitionId,
            resourceGroupName = resourceGroupName,
        )
        return getMongoDBResourceMongoUserDefinitionResultToKotlin(getMongoDBResourceMongoUserDefinitionPlain(argument.toJava()).await())
    }

    /**
     * @see [getMongoDBResourceMongoUserDefinition].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;documentdb&#46;kotlin&#46;inputs&#46;GetMongoDBResourceMongoUserDefinitionPlainArgs].
     * @return An Azure Cosmos DB User Definition
     */
    public suspend
    fun getMongoDBResourceMongoUserDefinition(argument: suspend GetMongoDBResourceMongoUserDefinitionPlainArgsBuilder.() -> Unit):
        GetMongoDBResourceMongoUserDefinitionResult {
        val builder = GetMongoDBResourceMongoUserDefinitionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMongoDBResourceMongoUserDefinitionResultToKotlin(getMongoDBResourceMongoUserDefinitionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the notebook workspace for a Cosmos DB account.
     * Azure REST API version: 2023-04-15.
     * Other available API versions: 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview.
     * @param argument null
     * @return A notebook workspace resource
     */
    public suspend fun getNotebookWorkspace(argument: GetNotebookWorkspacePlainArgs):
        GetNotebookWorkspaceResult =
        getNotebookWorkspaceResultToKotlin(getNotebookWorkspacePlain(argument.toJava()).await())

    /**
     * @see [getNotebookWorkspace].
     * @param accountName Cosmos DB database account name.
     * @param notebookWorkspaceName The name of the notebook workspace resource.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return A notebook workspace resource
     */
    public suspend fun getNotebookWorkspace(
        accountName: String,
        notebookWorkspaceName: String,
        resourceGroupName: String,
    ): GetNotebookWorkspaceResult {
        val argument = GetNotebookWorkspacePlainArgs(
            accountName = accountName,
            notebookWorkspaceName = notebookWorkspaceName,
            resourceGroupName = resourceGroupName,
        )
        return getNotebookWorkspaceResultToKotlin(getNotebookWorkspacePlain(argument.toJava()).await())
    }

    /**
     * @see [getNotebookWorkspace].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;documentdb&#46;kotlin&#46;inputs&#46;GetNotebookWorkspacePlainArgs].
     * @return A notebook workspace resource
     */
    public suspend
    fun getNotebookWorkspace(argument: suspend GetNotebookWorkspacePlainArgsBuilder.() -> Unit):
        GetNotebookWorkspaceResult {
        val builder = GetNotebookWorkspacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNotebookWorkspaceResultToKotlin(getNotebookWorkspacePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a private endpoint connection.
     * Azure REST API version: 2023-04-15.
     * Other available API versions: 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview.
     * @param argument null
     * @return A private endpoint connection
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs):
        GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param accountName Cosmos DB database account name.
     * @param privateEndpointConnectionName The name of the private endpoint connection.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return A private endpoint connection
     */
    public suspend fun getPrivateEndpointConnection(
        accountName: String,
        privateEndpointConnectionName: String,
        resourceGroupName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            accountName = accountName,
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;documentdb&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return A private endpoint connection
     */
    public suspend
    fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the status of service.
     * Azure REST API version: 2023-04-15.
     * Other available API versions: 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview.
     * @param argument null
     * @return Properties for the database account.
     */
    public suspend fun getService(argument: GetServicePlainArgs): GetServiceResult =
        getServiceResultToKotlin(getServicePlain(argument.toJava()).await())

    /**
     * @see [getService].
     * @param accountName Cosmos DB database account name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName Cosmos DB service name.
     * @return Properties for the database account.
     */
    public suspend fun getService(
        accountName: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetServiceResult {
        val argument = GetServicePlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getServiceResultToKotlin(getServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getService].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;documentdb&#46;kotlin&#46;inputs&#46;GetServicePlainArgs].
     * @return Properties for the database account.
     */
    public suspend fun getService(argument: suspend GetServicePlainArgsBuilder.() -> Unit):
        GetServiceResult {
        val builder = GetServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceResultToKotlin(getServicePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the SQL container under an existing Azure Cosmos DB database account.
     * Azure REST API version: 2023-04-15.
     * Other available API versions: 2019-08-01, 2023-03-15-preview, 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview.
     * @param argument null
     * @return An Azure Cosmos DB container.
     */
    public suspend fun getSqlResourceSqlContainer(argument: GetSqlResourceSqlContainerPlainArgs):
        GetSqlResourceSqlContainerResult =
        getSqlResourceSqlContainerResultToKotlin(getSqlResourceSqlContainerPlain(argument.toJava()).await())

    /**
     * @see [getSqlResourceSqlContainer].
     * @param accountName Cosmos DB database account name.
     * @param containerName Cosmos DB container name.
     * @param databaseName Cosmos DB database name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return An Azure Cosmos DB container.
     */
    public suspend fun getSqlResourceSqlContainer(
        accountName: String,
        containerName: String,
        databaseName: String,
        resourceGroupName: String,
    ): GetSqlResourceSqlContainerResult {
        val argument = GetSqlResourceSqlContainerPlainArgs(
            accountName = accountName,
            containerName = containerName,
            databaseName = databaseName,
            resourceGroupName = resourceGroupName,
        )
        return getSqlResourceSqlContainerResultToKotlin(getSqlResourceSqlContainerPlain(argument.toJava()).await())
    }

    /**
     * @see [getSqlResourceSqlContainer].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;documentdb&#46;kotlin&#46;inputs&#46;GetSqlResourceSqlContainerPlainArgs].
     * @return An Azure Cosmos DB container.
     */
    public suspend
    fun getSqlResourceSqlContainer(argument: suspend GetSqlResourceSqlContainerPlainArgsBuilder.() -> Unit):
        GetSqlResourceSqlContainerResult {
        val builder = GetSqlResourceSqlContainerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSqlResourceSqlContainerResultToKotlin(getSqlResourceSqlContainerPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the SQL database under an existing Azure Cosmos DB database account with the provided name.
     * Azure REST API version: 2023-04-15.
     * Other available API versions: 2019-08-01, 2023-03-15-preview, 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview.
     * @param argument null
     * @return An Azure Cosmos DB SQL database.
     */
    public suspend fun getSqlResourceSqlDatabase(argument: GetSqlResourceSqlDatabasePlainArgs):
        GetSqlResourceSqlDatabaseResult =
        getSqlResourceSqlDatabaseResultToKotlin(getSqlResourceSqlDatabasePlain(argument.toJava()).await())

    /**
     * @see [getSqlResourceSqlDatabase].
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return An Azure Cosmos DB SQL database.
     */
    public suspend fun getSqlResourceSqlDatabase(
        accountName: String,
        databaseName: String,
        resourceGroupName: String,
    ): GetSqlResourceSqlDatabaseResult {
        val argument = GetSqlResourceSqlDatabasePlainArgs(
            accountName = accountName,
            databaseName = databaseName,
            resourceGroupName = resourceGroupName,
        )
        return getSqlResourceSqlDatabaseResultToKotlin(getSqlResourceSqlDatabasePlain(argument.toJava()).await())
    }

    /**
     * @see [getSqlResourceSqlDatabase].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;documentdb&#46;kotlin&#46;inputs&#46;GetSqlResourceSqlDatabasePlainArgs].
     * @return An Azure Cosmos DB SQL database.
     */
    public suspend
    fun getSqlResourceSqlDatabase(argument: suspend GetSqlResourceSqlDatabasePlainArgsBuilder.() -> Unit):
        GetSqlResourceSqlDatabaseResult {
        val builder = GetSqlResourceSqlDatabasePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSqlResourceSqlDatabaseResultToKotlin(getSqlResourceSqlDatabasePlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves the properties of an existing Azure Cosmos DB SQL Role Assignment with the given Id.
     * Azure REST API version: 2023-04-15.
     * Other available API versions: 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview.
     * @param argument null
     * @return An Azure Cosmos DB Role Assignment
     */
    public suspend
    fun getSqlResourceSqlRoleAssignment(argument: GetSqlResourceSqlRoleAssignmentPlainArgs):
        GetSqlResourceSqlRoleAssignmentResult =
        getSqlResourceSqlRoleAssignmentResultToKotlin(getSqlResourceSqlRoleAssignmentPlain(argument.toJava()).await())

    /**
     * @see [getSqlResourceSqlRoleAssignment].
     * @param accountName Cosmos DB database account name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @return An Azure Cosmos DB Role Assignment
     */
    public suspend fun getSqlResourceSqlRoleAssignment(
        accountName: String,
        resourceGroupName: String,
        roleAssignmentId: String,
    ): GetSqlResourceSqlRoleAssignmentResult {
        val argument = GetSqlResourceSqlRoleAssignmentPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
            roleAssignmentId = roleAssignmentId,
        )
        return getSqlResourceSqlRoleAssignmentResultToKotlin(getSqlResourceSqlRoleAssignmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getSqlResourceSqlRoleAssignment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;documentdb&#46;kotlin&#46;inputs&#46;GetSqlResourceSqlRoleAssignmentPlainArgs].
     * @return An Azure Cosmos DB Role Assignment
     */
    public suspend
    fun getSqlResourceSqlRoleAssignment(argument: suspend GetSqlResourceSqlRoleAssignmentPlainArgsBuilder.() -> Unit):
        GetSqlResourceSqlRoleAssignmentResult {
        val builder = GetSqlResourceSqlRoleAssignmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSqlResourceSqlRoleAssignmentResultToKotlin(getSqlResourceSqlRoleAssignmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves the properties of an existing Azure Cosmos DB SQL Role Definition with the given Id.
     * Azure REST API version: 2023-04-15.
     * Other available API versions: 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview.
     * @param argument null
     * @return An Azure Cosmos DB SQL Role Definition.
     */
    public suspend
    fun getSqlResourceSqlRoleDefinition(argument: GetSqlResourceSqlRoleDefinitionPlainArgs):
        GetSqlResourceSqlRoleDefinitionResult =
        getSqlResourceSqlRoleDefinitionResultToKotlin(getSqlResourceSqlRoleDefinitionPlain(argument.toJava()).await())

    /**
     * @see [getSqlResourceSqlRoleDefinition].
     * @param accountName Cosmos DB database account name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param roleDefinitionId The GUID for the Role Definition.
     * @return An Azure Cosmos DB SQL Role Definition.
     */
    public suspend fun getSqlResourceSqlRoleDefinition(
        accountName: String,
        resourceGroupName: String,
        roleDefinitionId: String,
    ): GetSqlResourceSqlRoleDefinitionResult {
        val argument = GetSqlResourceSqlRoleDefinitionPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
            roleDefinitionId = roleDefinitionId,
        )
        return getSqlResourceSqlRoleDefinitionResultToKotlin(getSqlResourceSqlRoleDefinitionPlain(argument.toJava()).await())
    }

    /**
     * @see [getSqlResourceSqlRoleDefinition].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;documentdb&#46;kotlin&#46;inputs&#46;GetSqlResourceSqlRoleDefinitionPlainArgs].
     * @return An Azure Cosmos DB SQL Role Definition.
     */
    public suspend
    fun getSqlResourceSqlRoleDefinition(argument: suspend GetSqlResourceSqlRoleDefinitionPlainArgsBuilder.() -> Unit):
        GetSqlResourceSqlRoleDefinitionResult {
        val builder = GetSqlResourceSqlRoleDefinitionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSqlResourceSqlRoleDefinitionResultToKotlin(getSqlResourceSqlRoleDefinitionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the SQL storedProcedure under an existing Azure Cosmos DB database account.
     * Azure REST API version: 2023-04-15.
     * Other available API versions: 2019-08-01, 2023-03-15-preview, 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview.
     * @param argument null
     * @return An Azure Cosmos DB storedProcedure.
     */
    public suspend
    fun getSqlResourceSqlStoredProcedure(argument: GetSqlResourceSqlStoredProcedurePlainArgs):
        GetSqlResourceSqlStoredProcedureResult =
        getSqlResourceSqlStoredProcedureResultToKotlin(getSqlResourceSqlStoredProcedurePlain(argument.toJava()).await())

    /**
     * @see [getSqlResourceSqlStoredProcedure].
     * @param accountName Cosmos DB database account name.
     * @param containerName Cosmos DB container name.
     * @param databaseName Cosmos DB database name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @return An Azure Cosmos DB storedProcedure.
     */
    public suspend fun getSqlResourceSqlStoredProcedure(
        accountName: String,
        containerName: String,
        databaseName: String,
        resourceGroupName: String,
        storedProcedureName: String,
    ): GetSqlResourceSqlStoredProcedureResult {
        val argument = GetSqlResourceSqlStoredProcedurePlainArgs(
            accountName = accountName,
            containerName = containerName,
            databaseName = databaseName,
            resourceGroupName = resourceGroupName,
            storedProcedureName = storedProcedureName,
        )
        return getSqlResourceSqlStoredProcedureResultToKotlin(getSqlResourceSqlStoredProcedurePlain(argument.toJava()).await())
    }

    /**
     * @see [getSqlResourceSqlStoredProcedure].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;documentdb&#46;kotlin&#46;inputs&#46;GetSqlResourceSqlStoredProcedurePlainArgs].
     * @return An Azure Cosmos DB storedProcedure.
     */
    public suspend
    fun getSqlResourceSqlStoredProcedure(argument: suspend GetSqlResourceSqlStoredProcedurePlainArgsBuilder.() -> Unit):
        GetSqlResourceSqlStoredProcedureResult {
        val builder = GetSqlResourceSqlStoredProcedurePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSqlResourceSqlStoredProcedureResultToKotlin(getSqlResourceSqlStoredProcedurePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the SQL trigger under an existing Azure Cosmos DB database account.
     * Azure REST API version: 2023-04-15.
     * Other available API versions: 2019-08-01, 2023-03-15-preview, 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview.
     * @param argument null
     * @return An Azure Cosmos DB trigger.
     */
    public suspend fun getSqlResourceSqlTrigger(argument: GetSqlResourceSqlTriggerPlainArgs):
        GetSqlResourceSqlTriggerResult =
        getSqlResourceSqlTriggerResultToKotlin(getSqlResourceSqlTriggerPlain(argument.toJava()).await())

    /**
     * @see [getSqlResourceSqlTrigger].
     * @param accountName Cosmos DB database account name.
     * @param containerName Cosmos DB container name.
     * @param databaseName Cosmos DB database name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param triggerName Cosmos DB trigger name.
     * @return An Azure Cosmos DB trigger.
     */
    public suspend fun getSqlResourceSqlTrigger(
        accountName: String,
        containerName: String,
        databaseName: String,
        resourceGroupName: String,
        triggerName: String,
    ): GetSqlResourceSqlTriggerResult {
        val argument = GetSqlResourceSqlTriggerPlainArgs(
            accountName = accountName,
            containerName = containerName,
            databaseName = databaseName,
            resourceGroupName = resourceGroupName,
            triggerName = triggerName,
        )
        return getSqlResourceSqlTriggerResultToKotlin(getSqlResourceSqlTriggerPlain(argument.toJava()).await())
    }

    /**
     * @see [getSqlResourceSqlTrigger].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;documentdb&#46;kotlin&#46;inputs&#46;GetSqlResourceSqlTriggerPlainArgs].
     * @return An Azure Cosmos DB trigger.
     */
    public suspend
    fun getSqlResourceSqlTrigger(argument: suspend GetSqlResourceSqlTriggerPlainArgsBuilder.() -> Unit):
        GetSqlResourceSqlTriggerResult {
        val builder = GetSqlResourceSqlTriggerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSqlResourceSqlTriggerResultToKotlin(getSqlResourceSqlTriggerPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the SQL userDefinedFunction under an existing Azure Cosmos DB database account.
     * Azure REST API version: 2023-04-15.
     * Other available API versions: 2019-08-01, 2023-03-15-preview, 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview.
     * @param argument null
     * @return An Azure Cosmos DB userDefinedFunction.
     */
    public suspend
    fun getSqlResourceSqlUserDefinedFunction(argument: GetSqlResourceSqlUserDefinedFunctionPlainArgs):
        GetSqlResourceSqlUserDefinedFunctionResult =
        getSqlResourceSqlUserDefinedFunctionResultToKotlin(getSqlResourceSqlUserDefinedFunctionPlain(argument.toJava()).await())

    /**
     * @see [getSqlResourceSqlUserDefinedFunction].
     * @param accountName Cosmos DB database account name.
     * @param containerName Cosmos DB container name.
     * @param databaseName Cosmos DB database name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @return An Azure Cosmos DB userDefinedFunction.
     */
    public suspend fun getSqlResourceSqlUserDefinedFunction(
        accountName: String,
        containerName: String,
        databaseName: String,
        resourceGroupName: String,
        userDefinedFunctionName: String,
    ): GetSqlResourceSqlUserDefinedFunctionResult {
        val argument = GetSqlResourceSqlUserDefinedFunctionPlainArgs(
            accountName = accountName,
            containerName = containerName,
            databaseName = databaseName,
            resourceGroupName = resourceGroupName,
            userDefinedFunctionName = userDefinedFunctionName,
        )
        return getSqlResourceSqlUserDefinedFunctionResultToKotlin(getSqlResourceSqlUserDefinedFunctionPlain(argument.toJava()).await())
    }

    /**
     * @see [getSqlResourceSqlUserDefinedFunction].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;documentdb&#46;kotlin&#46;inputs&#46;GetSqlResourceSqlUserDefinedFunctionPlainArgs].
     * @return An Azure Cosmos DB userDefinedFunction.
     */
    public suspend
    fun getSqlResourceSqlUserDefinedFunction(argument: suspend GetSqlResourceSqlUserDefinedFunctionPlainArgsBuilder.() -> Unit):
        GetSqlResourceSqlUserDefinedFunctionResult {
        val builder = GetSqlResourceSqlUserDefinedFunctionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSqlResourceSqlUserDefinedFunctionResultToKotlin(getSqlResourceSqlUserDefinedFunctionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the Tables under an existing Azure Cosmos DB database account with the provided name.
     * Azure REST API version: 2023-04-15.
     * Other available API versions: 2019-08-01, 2023-03-15-preview, 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview.
     * @param argument null
     * @return An Azure Cosmos DB Table.
     */
    public suspend fun getTableResourceTable(argument: GetTableResourceTablePlainArgs):
        GetTableResourceTableResult =
        getTableResourceTableResultToKotlin(getTableResourceTablePlain(argument.toJava()).await())

    /**
     * @see [getTableResourceTable].
     * @param accountName Cosmos DB database account name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param tableName Cosmos DB table name.
     * @return An Azure Cosmos DB Table.
     */
    public suspend fun getTableResourceTable(
        accountName: String,
        resourceGroupName: String,
        tableName: String,
    ): GetTableResourceTableResult {
        val argument = GetTableResourceTablePlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
            tableName = tableName,
        )
        return getTableResourceTableResultToKotlin(getTableResourceTablePlain(argument.toJava()).await())
    }

    /**
     * @see [getTableResourceTable].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;documentdb&#46;kotlin&#46;inputs&#46;GetTableResourceTablePlainArgs].
     * @return An Azure Cosmos DB Table.
     */
    public suspend
    fun getTableResourceTable(argument: suspend GetTableResourceTablePlainArgsBuilder.() -> Unit):
        GetTableResourceTableResult {
        val builder = GetTableResourceTablePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTableResourceTableResultToKotlin(getTableResourceTablePlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves the properties of an existing Azure Cosmos DB Throughput Pool
     * Azure REST API version: 2023-11-15-preview.
     * @param argument null
     * @return An Azure Cosmos DB Throughputpool.
     */
    public suspend fun getThroughputPool(argument: GetThroughputPoolPlainArgs):
        GetThroughputPoolResult =
        getThroughputPoolResultToKotlin(getThroughputPoolPlain(argument.toJava()).await())

    /**
     * @see [getThroughputPool].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param throughputPoolName Cosmos DB Throughput Pool name.
     * @return An Azure Cosmos DB Throughputpool.
     */
    public suspend fun getThroughputPool(resourceGroupName: String, throughputPoolName: String):
        GetThroughputPoolResult {
        val argument = GetThroughputPoolPlainArgs(
            resourceGroupName = resourceGroupName,
            throughputPoolName = throughputPoolName,
        )
        return getThroughputPoolResultToKotlin(getThroughputPoolPlain(argument.toJava()).await())
    }

    /**
     * @see [getThroughputPool].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;documentdb&#46;kotlin&#46;inputs&#46;GetThroughputPoolPlainArgs].
     * @return An Azure Cosmos DB Throughputpool.
     */
    public suspend
    fun getThroughputPool(argument: suspend GetThroughputPoolPlainArgsBuilder.() -> Unit):
        GetThroughputPoolResult {
        val builder = GetThroughputPoolPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getThroughputPoolResultToKotlin(getThroughputPoolPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves the properties of an existing Azure Cosmos DB Throughput Pool
     * Azure REST API version: 2023-11-15-preview.
     * @param argument null
     * @return An Azure Cosmos DB Throughputpool Account
     */
    public suspend fun getThroughputPoolAccount(argument: GetThroughputPoolAccountPlainArgs):
        GetThroughputPoolAccountResult =
        getThroughputPoolAccountResultToKotlin(getThroughputPoolAccountPlain(argument.toJava()).await())

    /**
     * @see [getThroughputPoolAccount].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param throughputPoolAccountName Cosmos DB global database account in a Throughput Pool
     * @param throughputPoolName Cosmos DB Throughput Pool name.
     * @return An Azure Cosmos DB Throughputpool Account
     */
    public suspend fun getThroughputPoolAccount(
        resourceGroupName: String,
        throughputPoolAccountName: String,
        throughputPoolName: String,
    ): GetThroughputPoolAccountResult {
        val argument = GetThroughputPoolAccountPlainArgs(
            resourceGroupName = resourceGroupName,
            throughputPoolAccountName = throughputPoolAccountName,
            throughputPoolName = throughputPoolName,
        )
        return getThroughputPoolAccountResultToKotlin(getThroughputPoolAccountPlain(argument.toJava()).await())
    }

    /**
     * @see [getThroughputPoolAccount].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;documentdb&#46;kotlin&#46;inputs&#46;GetThroughputPoolAccountPlainArgs].
     * @return An Azure Cosmos DB Throughputpool Account
     */
    public suspend
    fun getThroughputPoolAccount(argument: suspend GetThroughputPoolAccountPlainArgsBuilder.() -> Unit):
        GetThroughputPoolAccountResult {
        val builder = GetThroughputPoolAccountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getThroughputPoolAccountResultToKotlin(getThroughputPoolAccountPlain(builtArgument.toJava()).await())
    }

    /**
     * Lists the connection strings for the specified Azure Cosmos DB database account.
     * Azure REST API version: 2023-04-15.
     * Other available API versions: 2020-03-01, 2020-06-01-preview, 2020-09-01, 2021-04-01-preview, 2023-03-15-preview, 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview.
     * @param argument null
     * @return The connection strings for the given database account.
     */
    public suspend
    fun listDatabaseAccountConnectionStrings(argument: ListDatabaseAccountConnectionStringsPlainArgs):
        ListDatabaseAccountConnectionStringsResult =
        listDatabaseAccountConnectionStringsResultToKotlin(listDatabaseAccountConnectionStringsPlain(argument.toJava()).await())

    /**
     * @see [listDatabaseAccountConnectionStrings].
     * @param accountName Cosmos DB database account name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The connection strings for the given database account.
     */
    public suspend fun listDatabaseAccountConnectionStrings(
        accountName: String,
        resourceGroupName: String,
    ): ListDatabaseAccountConnectionStringsResult {
        val argument = ListDatabaseAccountConnectionStringsPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
        )
        return listDatabaseAccountConnectionStringsResultToKotlin(listDatabaseAccountConnectionStringsPlain(argument.toJava()).await())
    }

    /**
     * @see [listDatabaseAccountConnectionStrings].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;documentdb&#46;kotlin&#46;inputs&#46;ListDatabaseAccountConnectionStringsPlainArgs].
     * @return The connection strings for the given database account.
     */
    public suspend
    fun listDatabaseAccountConnectionStrings(argument: suspend ListDatabaseAccountConnectionStringsPlainArgsBuilder.() -> Unit):
        ListDatabaseAccountConnectionStringsResult {
        val builder = ListDatabaseAccountConnectionStringsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listDatabaseAccountConnectionStringsResultToKotlin(listDatabaseAccountConnectionStringsPlain(builtArgument.toJava()).await())
    }

    /**
     * Lists the access keys for the specified Azure Cosmos DB database account.
     * Azure REST API version: 2023-04-15.
     * Other available API versions: 2020-03-01, 2020-06-01-preview, 2020-09-01, 2021-04-01-preview, 2023-03-15-preview, 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview.
     * @param argument null
     * @return The access keys for the given database account.
     */
    public suspend fun listDatabaseAccountKeys(argument: ListDatabaseAccountKeysPlainArgs):
        ListDatabaseAccountKeysResult =
        listDatabaseAccountKeysResultToKotlin(listDatabaseAccountKeysPlain(argument.toJava()).await())

    /**
     * @see [listDatabaseAccountKeys].
     * @param accountName Cosmos DB database account name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The access keys for the given database account.
     */
    public suspend fun listDatabaseAccountKeys(accountName: String, resourceGroupName: String):
        ListDatabaseAccountKeysResult {
        val argument = ListDatabaseAccountKeysPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
        )
        return listDatabaseAccountKeysResultToKotlin(listDatabaseAccountKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listDatabaseAccountKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;documentdb&#46;kotlin&#46;inputs&#46;ListDatabaseAccountKeysPlainArgs].
     * @return The access keys for the given database account.
     */
    public suspend
    fun listDatabaseAccountKeys(argument: suspend ListDatabaseAccountKeysPlainArgsBuilder.() -> Unit):
        ListDatabaseAccountKeysResult {
        val builder = ListDatabaseAccountKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listDatabaseAccountKeysResultToKotlin(listDatabaseAccountKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * List mongo cluster connection strings. This includes the default connection string using SCRAM-SHA-256, as well as other connection strings supported by the cluster.
     * Azure REST API version: 2023-03-15-preview.
     * Other available API versions: 2023-09-15-preview, 2023-11-15-preview.
     * @param argument null
     * @return The connection strings for the given mongo cluster.
     */
    public suspend
    fun listMongoClusterConnectionStrings(argument: ListMongoClusterConnectionStringsPlainArgs):
        ListMongoClusterConnectionStringsResult =
        listMongoClusterConnectionStringsResultToKotlin(listMongoClusterConnectionStringsPlain(argument.toJava()).await())

    /**
     * @see [listMongoClusterConnectionStrings].
     * @param mongoClusterName The name of the mongo cluster.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The connection strings for the given mongo cluster.
     */
    public suspend fun listMongoClusterConnectionStrings(
        mongoClusterName: String,
        resourceGroupName: String,
    ): ListMongoClusterConnectionStringsResult {
        val argument = ListMongoClusterConnectionStringsPlainArgs(
            mongoClusterName = mongoClusterName,
            resourceGroupName = resourceGroupName,
        )
        return listMongoClusterConnectionStringsResultToKotlin(listMongoClusterConnectionStringsPlain(argument.toJava()).await())
    }

    /**
     * @see [listMongoClusterConnectionStrings].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;documentdb&#46;kotlin&#46;inputs&#46;ListMongoClusterConnectionStringsPlainArgs].
     * @return The connection strings for the given mongo cluster.
     */
    public suspend
    fun listMongoClusterConnectionStrings(argument: suspend ListMongoClusterConnectionStringsPlainArgsBuilder.() -> Unit):
        ListMongoClusterConnectionStringsResult {
        val builder = ListMongoClusterConnectionStringsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listMongoClusterConnectionStringsResultToKotlin(listMongoClusterConnectionStringsPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves the connection info for the notebook workspace
     * Azure REST API version: 2023-04-15.
     * Other available API versions: 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview.
     * @param argument null
     * @return The connection info for the given notebook workspace
     */
    public suspend
    fun listNotebookWorkspaceConnectionInfo(argument: ListNotebookWorkspaceConnectionInfoPlainArgs):
        ListNotebookWorkspaceConnectionInfoResult =
        listNotebookWorkspaceConnectionInfoResultToKotlin(listNotebookWorkspaceConnectionInfoPlain(argument.toJava()).await())

    /**
     * @see [listNotebookWorkspaceConnectionInfo].
     * @param accountName Cosmos DB database account name.
     * @param notebookWorkspaceName The name of the notebook workspace resource.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The connection info for the given notebook workspace
     */
    public suspend fun listNotebookWorkspaceConnectionInfo(
        accountName: String,
        notebookWorkspaceName: String,
        resourceGroupName: String,
    ): ListNotebookWorkspaceConnectionInfoResult {
        val argument = ListNotebookWorkspaceConnectionInfoPlainArgs(
            accountName = accountName,
            notebookWorkspaceName = notebookWorkspaceName,
            resourceGroupName = resourceGroupName,
        )
        return listNotebookWorkspaceConnectionInfoResultToKotlin(listNotebookWorkspaceConnectionInfoPlain(argument.toJava()).await())
    }

    /**
     * @see [listNotebookWorkspaceConnectionInfo].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;documentdb&#46;kotlin&#46;inputs&#46;ListNotebookWorkspaceConnectionInfoPlainArgs].
     * @return The connection info for the given notebook workspace
     */
    public suspend
    fun listNotebookWorkspaceConnectionInfo(argument: suspend ListNotebookWorkspaceConnectionInfoPlainArgsBuilder.() -> Unit):
        ListNotebookWorkspaceConnectionInfoResult {
        val builder = ListNotebookWorkspaceConnectionInfoPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listNotebookWorkspaceConnectionInfoResultToKotlin(listNotebookWorkspaceConnectionInfoPlain(builtArgument.toJava()).await())
    }
}
