@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.azurenative.documentdb.kotlin.outputs.GraphResourceGetPropertiesResponseOptions
import com.pulumi.azurenative.documentdb.kotlin.outputs.GraphResourceGetPropertiesResponseResource
import com.pulumi.azurenative.documentdb.kotlin.outputs.ManagedServiceIdentityResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.documentdb.kotlin.outputs.GraphResourceGetPropertiesResponseOptions.Companion.toKotlin as graphResourceGetPropertiesResponseOptionsToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.GraphResourceGetPropertiesResponseResource.Companion.toKotlin as graphResourceGetPropertiesResponseResourceToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin as managedServiceIdentityResponseToKotlin

/**
 * Builder for [GraphResourceGraph].
 */
@PulumiTagMarker
public class GraphResourceGraphResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GraphResourceGraphArgs = GraphResourceGraphArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GraphResourceGraphArgsBuilder.() -> Unit) {
        val builder = GraphResourceGraphArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): GraphResourceGraph {
        val builtJavaResource =
            com.pulumi.azurenative.documentdb.GraphResourceGraph(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return GraphResourceGraph(builtJavaResource)
    }
}

/**
 * An Azure Cosmos DB Graph resource.
 * Azure REST API version: 2023-03-15-preview. Prior API version in Azure Native 1.x: 2021-07-01-preview.
 * Other available API versions: 2023-09-15-preview, 2023-11-15-preview.
 * ## Example Usage
 * ### CosmosDBGraphCreateUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var graphResourceGraph = new AzureNative.DocumentDB.GraphResourceGraph("graphResourceGraph", new()
 *     {
 *         AccountName = "ddb1",
 *         GraphName = "graphName",
 *         Location = "West US",
 *         Options = null,
 *         Resource = new AzureNative.DocumentDB.Inputs.GraphResourceArgs
 *         {
 *             Id = "graphName",
 *         },
 *         ResourceGroupName = "rg1",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewGraphResourceGraph(ctx, "graphResourceGraph", &documentdb.GraphResourceGraphArgs{
 * 			AccountName: pulumi.String("ddb1"),
 * 			GraphName:   pulumi.String("graphName"),
 * 			Location:    pulumi.String("West US"),
 * 			Options:     nil,
 * 			Resource: &documentdb.GraphResourceArgs{
 * 				Id: pulumi.String("graphName"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.GraphResourceGraph;
 * import com.pulumi.azurenative.documentdb.GraphResourceGraphArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var graphResourceGraph = new GraphResourceGraph("graphResourceGraph", GraphResourceGraphArgs.builder()
 *             .accountName("ddb1")
 *             .graphName("graphName")
 *             .location("West US")
 *             .options()
 *             .resource(Map.of("id", "graphName"))
 *             .resourceGroupName("rg1")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:GraphResourceGraph graphName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/graphs/{graphName}
 * ```
 */
public class GraphResourceGraph internal constructor(
    override val javaResource: com.pulumi.azurenative.documentdb.GraphResourceGraph,
) : KotlinCustomResource(javaResource, GraphResourceGraphMapper) {
    /**
     * Identity for the resource.
     */
    public val identity: Output<ManagedServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The location of the resource group to which the resource belongs.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the ARM resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val options: Output<GraphResourceGetPropertiesResponseOptions>?
        get() = javaResource.options().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    graphResourceGetPropertiesResponseOptionsToKotlin(args0)
                })
            }).orElse(null)
        })

    public val resource: Output<GraphResourceGetPropertiesResponseResource>?
        get() = javaResource.resource().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    graphResourceGetPropertiesResponseResourceToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of Azure resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object GraphResourceGraphMapper : ResourceMapper<GraphResourceGraph> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.documentdb.GraphResourceGraph::class == javaResource::class

    override fun map(javaResource: Resource): GraphResourceGraph = GraphResourceGraph(
        javaResource as
            com.pulumi.azurenative.documentdb.GraphResourceGraph,
    )
}

/**
 * @see [GraphResourceGraph].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GraphResourceGraph].
 */
public suspend fun graphResourceGraph(
    name: String,
    block: suspend GraphResourceGraphResourceBuilder.() -> Unit,
): GraphResourceGraph {
    val builder = GraphResourceGraphResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GraphResourceGraph].
 * @param name The _unique_ name of the resulting resource.
 */
public fun graphResourceGraph(name: String): GraphResourceGraph {
    val builder = GraphResourceGraphResourceBuilder()
    builder.name(name)
    return builder.build()
}
