@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.azurenative.documentdb.kotlin.outputs.NodeGroupSpecResponse
import com.pulumi.azurenative.documentdb.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.documentdb.kotlin.outputs.NodeGroupSpecResponse.Companion.toKotlin as nodeGroupSpecResponseToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [MongoCluster].
 */
@PulumiTagMarker
public class MongoClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MongoClusterArgs = MongoClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MongoClusterArgsBuilder.() -> Unit) {
        val builder = MongoClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): MongoCluster {
        val builtJavaResource = com.pulumi.azurenative.documentdb.MongoCluster(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MongoCluster(builtJavaResource)
    }
}

/**
 * Represents a mongo cluster resource.
 * Azure REST API version: 2023-03-15-preview.
 * Other available API versions: 2023-09-15-preview, 2023-11-15-preview.
 * ## Example Usage
 * ### Create a new mongo cluster
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var mongoCluster = new AzureNative.DocumentDB.MongoCluster("mongoCluster", new()
 *     {
 *         AdministratorLogin = "mongoAdmin",
 *         AdministratorLoginPassword = "password",
 *         Location = "westus2",
 *         MongoClusterName = "myMongoCluster",
 *         NodeGroupSpecs = new[]
 *         {
 *             new AzureNative.DocumentDB.Inputs.NodeGroupSpecArgs
 *             {
 *                 DiskSizeGB = 128,
 *                 EnableHa = true,
 *                 Kind = "Shard",
 *                 NodeCount = 3,
 *                 Sku = "M30",
 *             },
 *         },
 *         ResourceGroupName = "TestResourceGroup",
 *         ServerVersion = "5.0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewMongoCluster(ctx, "mongoCluster", &documentdb.MongoClusterArgs{
 * 			AdministratorLogin:         pulumi.String("mongoAdmin"),
 * 			AdministratorLoginPassword: pulumi.String("password"),
 * 			Location:                   pulumi.String("westus2"),
 * 			MongoClusterName:           pulumi.String("myMongoCluster"),
 * 			NodeGroupSpecs: []documentdb.NodeGroupSpecArgs{
 * 				{
 * 					DiskSizeGB: pulumi.Float64(128),
 * 					EnableHa:   pulumi.Bool(true),
 * 					Kind:       pulumi.String("Shard"),
 * 					NodeCount:  pulumi.Int(3),
 * 					Sku:        pulumi.String("M30"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("TestResourceGroup"),
 * 			ServerVersion:     pulumi.String("5.0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.MongoCluster;
 * import com.pulumi.azurenative.documentdb.MongoClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mongoCluster = new MongoCluster("mongoCluster", MongoClusterArgs.builder()
 *             .administratorLogin("mongoAdmin")
 *             .administratorLoginPassword("password")
 *             .location("westus2")
 *             .mongoClusterName("myMongoCluster")
 *             .nodeGroupSpecs(Map.ofEntries(
 *                 Map.entry("diskSizeGB", 128),
 *                 Map.entry("enableHa", true),
 *                 Map.entry("kind", "Shard"),
 *                 Map.entry("nodeCount", 3),
 *                 Map.entry("sku", "M30")
 *             ))
 *             .resourceGroupName("TestResourceGroup")
 *             .serverVersion("5.0")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a new mongo cluster with point in time restore
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var mongoCluster = new AzureNative.DocumentDB.MongoCluster("mongoCluster", new()
 *     {
 *         CreateMode = "PointInTimeRestore",
 *         Location = "westus2",
 *         MongoClusterName = "myMongoCluster",
 *         ResourceGroupName = "TestResourceGroup",
 *         RestoreParameters = new AzureNative.DocumentDB.Inputs.MongoClusterRestoreParametersArgs
 *         {
 *             PointInTimeUTC = "2023-01-13T20:07:35Z",
 *             SourceResourceId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestResourceGroup/providers/Microsoft.DocumentDB/mongoClusters/myOtherMongoCluster",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewMongoCluster(ctx, "mongoCluster", &documentdb.MongoClusterArgs{
 * 			CreateMode:        pulumi.String("PointInTimeRestore"),
 * 			Location:          pulumi.String("westus2"),
 * 			MongoClusterName:  pulumi.String("myMongoCluster"),
 * 			ResourceGroupName: pulumi.String("TestResourceGroup"),
 * 			RestoreParameters: &documentdb.MongoClusterRestoreParametersArgs{
 * 				PointInTimeUTC:   pulumi.String("2023-01-13T20:07:35Z"),
 * 				SourceResourceId: pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestResourceGroup/providers/Microsoft.DocumentDB/mongoClusters/myOtherMongoCluster"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.MongoCluster;
 * import com.pulumi.azurenative.documentdb.MongoClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mongoCluster = new MongoCluster("mongoCluster", MongoClusterArgs.builder()
 *             .createMode("PointInTimeRestore")
 *             .location("westus2")
 *             .mongoClusterName("myMongoCluster")
 *             .resourceGroupName("TestResourceGroup")
 *             .restoreParameters(Map.ofEntries(
 *                 Map.entry("pointInTimeUTC", "2023-01-13T20:07:35Z"),
 *                 Map.entry("sourceResourceId", "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestResourceGroup/providers/Microsoft.DocumentDB/mongoClusters/myOtherMongoCluster")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:MongoCluster myMongoCluster /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/mongoClusters/{mongoClusterName}
 * ```
 */
public class MongoCluster internal constructor(
    override val javaResource: com.pulumi.azurenative.documentdb.MongoCluster,
) : KotlinCustomResource(javaResource, MongoClusterMapper) {
    /**
     * The administrator's login for the mongo cluster.
     */
    public val administratorLogin: Output<String>?
        get() = javaResource.administratorLogin().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A status of the mongo cluster.
     */
    public val clusterStatus: Output<String>
        get() = javaResource.clusterStatus().applyValue({ args0 -> args0 })

    /**
     * The default mongo connection string for the cluster.
     */
    public val connectionString: Output<String>
        get() = javaResource.connectionString().applyValue({ args0 -> args0 })

    /**
     * Earliest restore timestamp in UTC ISO8601 format.
     */
    public val earliestRestoreTime: Output<String>
        get() = javaResource.earliestRestoreTime().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The list of node group specs in the cluster.
     */
    public val nodeGroupSpecs: Output<List<NodeGroupSpecResponse>>?
        get() = javaResource.nodeGroupSpecs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        nodeGroupSpecResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * A provisioning state of the mongo cluster.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The Mongo DB server version. Defaults to the latest available version if not specified.
     */
    public val serverVersion: Output<String>?
        get() = javaResource.serverVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object MongoClusterMapper : ResourceMapper<MongoCluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.documentdb.MongoCluster::class == javaResource::class

    override fun map(javaResource: Resource): MongoCluster = MongoCluster(
        javaResource as
            com.pulumi.azurenative.documentdb.MongoCluster,
    )
}

/**
 * @see [MongoCluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MongoCluster].
 */
public suspend fun mongoCluster(
    name: String,
    block: suspend MongoClusterResourceBuilder.() -> Unit,
): MongoCluster {
    val builder = MongoClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MongoCluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun mongoCluster(name: String): MongoCluster {
    val builder = MongoClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
