@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.azurenative.documentdb.kotlin.outputs.RoleResponse
import com.pulumi.azurenative.documentdb.kotlin.outputs.RoleResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [MongoDBResourceMongoUserDefinition].
 */
@PulumiTagMarker
public class MongoDBResourceMongoUserDefinitionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MongoDBResourceMongoUserDefinitionArgs = MongoDBResourceMongoUserDefinitionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MongoDBResourceMongoUserDefinitionArgsBuilder.() -> Unit) {
        val builder = MongoDBResourceMongoUserDefinitionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): MongoDBResourceMongoUserDefinition {
        val builtJavaResource =
            com.pulumi.azurenative.documentdb.MongoDBResourceMongoUserDefinition(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return MongoDBResourceMongoUserDefinition(builtJavaResource)
    }
}

/**
 * An Azure Cosmos DB User Definition
 * Azure REST API version: 2023-04-15. Prior API version in Azure Native 1.x: 2021-10-15-preview.
 * Other available API versions: 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview.
 * ## Example Usage
 * ### CosmosDBMongoDBUserDefinitionCreateUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var mongoDBResourceMongoUserDefinition = new AzureNative.DocumentDB.MongoDBResourceMongoUserDefinition("mongoDBResourceMongoUserDefinition", new()
 *     {
 *         AccountName = "myAccountName",
 *         CustomData = "My custom data",
 *         DatabaseName = "sales",
 *         Mechanisms = "SCRAM-SHA-256",
 *         MongoUserDefinitionId = "myMongoUserDefinitionId",
 *         Password = "myPassword",
 *         ResourceGroupName = "myResourceGroupName",
 *         Roles = new[]
 *         {
 *             new AzureNative.DocumentDB.Inputs.RoleArgs
 *             {
 *                 Db = "sales",
 *                 Role = "myReadRole",
 *             },
 *         },
 *         UserName = "myUserName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewMongoDBResourceMongoUserDefinition(ctx, "mongoDBResourceMongoUserDefinition", &documentdb.MongoDBResourceMongoUserDefinitionArgs{
 * 			AccountName:           pulumi.String("myAccountName"),
 * 			CustomData:            pulumi.String("My custom data"),
 * 			DatabaseName:          pulumi.String("sales"),
 * 			Mechanisms:            pulumi.String("SCRAM-SHA-256"),
 * 			MongoUserDefinitionId: pulumi.String("myMongoUserDefinitionId"),
 * 			Password:              pulumi.String("myPassword"),
 * 			ResourceGroupName:     pulumi.String("myResourceGroupName"),
 * 			Roles: []documentdb.RoleArgs{
 * 				{
 * 					Db:   pulumi.String("sales"),
 * 					Role: pulumi.String("myReadRole"),
 * 				},
 * 			},
 * 			UserName: pulumi.String("myUserName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.MongoDBResourceMongoUserDefinition;
 * import com.pulumi.azurenative.documentdb.MongoDBResourceMongoUserDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mongoDBResourceMongoUserDefinition = new MongoDBResourceMongoUserDefinition("mongoDBResourceMongoUserDefinition", MongoDBResourceMongoUserDefinitionArgs.builder()
 *             .accountName("myAccountName")
 *             .customData("My custom data")
 *             .databaseName("sales")
 *             .mechanisms("SCRAM-SHA-256")
 *             .mongoUserDefinitionId("myMongoUserDefinitionId")
 *             .password("myPassword")
 *             .resourceGroupName("myResourceGroupName")
 *             .roles(Map.ofEntries(
 *                 Map.entry("db", "sales"),
 *                 Map.entry("role", "myReadRole")
 *             ))
 *             .userName("myUserName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:MongoDBResourceMongoUserDefinition myUserName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/mongodbUserDefinitions/{mongoUserDefinitionId}
 * ```
 */
public class MongoDBResourceMongoUserDefinition internal constructor(
    override val javaResource: com.pulumi.azurenative.documentdb.MongoDBResourceMongoUserDefinition,
) : KotlinCustomResource(javaResource, MongoDBResourceMongoUserDefinitionMapper) {
    /**
     * A custom definition for the USer Definition.
     */
    public val customData: Output<String>?
        get() = javaResource.customData().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The database name for which access is being granted for this User Definition.
     */
    public val databaseName: Output<String>?
        get() = javaResource.databaseName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Mongo Auth mechanism. For now, we only support auth mechanism SCRAM-SHA-256.
     */
    public val mechanisms: Output<String>?
        get() = javaResource.mechanisms().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the database account.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The password for User Definition. Response does not contain user password.
     */
    public val password: Output<String>?
        get() = javaResource.password().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The set of roles inherited by the User Definition.
     */
    public val roles: Output<List<RoleResponse>>?
        get() = javaResource.roles().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The type of Azure resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The user name for User Definition.
     */
    public val userName: Output<String>?
        get() = javaResource.userName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object MongoDBResourceMongoUserDefinitionMapper :
    ResourceMapper<MongoDBResourceMongoUserDefinition> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.documentdb.MongoDBResourceMongoUserDefinition::class == javaResource::class

    override fun map(javaResource: Resource): MongoDBResourceMongoUserDefinition =
        MongoDBResourceMongoUserDefinition(
            javaResource as
                com.pulumi.azurenative.documentdb.MongoDBResourceMongoUserDefinition,
        )
}

/**
 * @see [MongoDBResourceMongoUserDefinition].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MongoDBResourceMongoUserDefinition].
 */
public suspend fun mongoDBResourceMongoUserDefinition(
    name: String,
    block: suspend MongoDBResourceMongoUserDefinitionResourceBuilder.() -> Unit,
):
    MongoDBResourceMongoUserDefinition {
    val builder = MongoDBResourceMongoUserDefinitionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MongoDBResourceMongoUserDefinition].
 * @param name The _unique_ name of the resulting resource.
 */
public fun mongoDBResourceMongoUserDefinition(name: String): MongoDBResourceMongoUserDefinition {
    val builder = MongoDBResourceMongoUserDefinitionResourceBuilder()
    builder.name(name)
    return builder.build()
}
