@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Service].
 */
@PulumiTagMarker
public class ServiceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceArgs = ServiceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceArgsBuilder.() -> Unit) {
        val builder = ServiceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Service {
        val builtJavaResource = com.pulumi.azurenative.documentdb.Service(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Service(builtJavaResource)
    }
}

/**
 * Properties for the database account.
 * Azure REST API version: 2023-04-15. Prior API version in Azure Native 1.x: 2021-04-01-preview.
 * Other available API versions: 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview.
 * ## Example Usage
 * ### DataTransferServiceCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.DocumentDB.Service("service", new()
 *     {
 *         AccountName = "ddb1",
 *         InstanceCount = 1,
 *         InstanceSize = "Cosmos.D4s",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "DataTransfer",
 *         ServiceType = "DataTransfer",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewService(ctx, "service", &documentdb.ServiceArgs{
 * 			AccountName:       pulumi.String("ddb1"),
 * 			InstanceCount:     pulumi.Int(1),
 * 			InstanceSize:      pulumi.String("Cosmos.D4s"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("DataTransfer"),
 * 			ServiceType:       pulumi.String("DataTransfer"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.Service;
 * import com.pulumi.azurenative.documentdb.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .accountName("ddb1")
 *             .instanceCount(1)
 *             .instanceSize("Cosmos.D4s")
 *             .resourceGroupName("rg1")
 *             .serviceName("DataTransfer")
 *             .serviceType("DataTransfer")
 *             .build());
 *     }
 * }
 * ```
 * ### GraphAPIComputeServiceCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.DocumentDB.Service("service", new()
 *     {
 *         AccountName = "ddb1",
 *         InstanceCount = 1,
 *         InstanceSize = "Cosmos.D4s",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "GraphAPICompute",
 *         ServiceType = "GraphAPICompute",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewService(ctx, "service", &documentdb.ServiceArgs{
 * 			AccountName:       pulumi.String("ddb1"),
 * 			InstanceCount:     pulumi.Int(1),
 * 			InstanceSize:      pulumi.String("Cosmos.D4s"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("GraphAPICompute"),
 * 			ServiceType:       pulumi.String("GraphAPICompute"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.Service;
 * import com.pulumi.azurenative.documentdb.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .accountName("ddb1")
 *             .instanceCount(1)
 *             .instanceSize("Cosmos.D4s")
 *             .resourceGroupName("rg1")
 *             .serviceName("GraphAPICompute")
 *             .serviceType("GraphAPICompute")
 *             .build());
 *     }
 * }
 * ```
 * ### MaterializedViewsBuilderServiceCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.DocumentDB.Service("service", new()
 *     {
 *         AccountName = "ddb1",
 *         InstanceCount = 1,
 *         InstanceSize = "Cosmos.D4s",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "MaterializedViewsBuilder",
 *         ServiceType = "MaterializedViewsBuilder",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewService(ctx, "service", &documentdb.ServiceArgs{
 * 			AccountName:       pulumi.String("ddb1"),
 * 			InstanceCount:     pulumi.Int(1),
 * 			InstanceSize:      pulumi.String("Cosmos.D4s"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("MaterializedViewsBuilder"),
 * 			ServiceType:       pulumi.String("MaterializedViewsBuilder"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.Service;
 * import com.pulumi.azurenative.documentdb.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .accountName("ddb1")
 *             .instanceCount(1)
 *             .instanceSize("Cosmos.D4s")
 *             .resourceGroupName("rg1")
 *             .serviceName("MaterializedViewsBuilder")
 *             .serviceType("MaterializedViewsBuilder")
 *             .build());
 *     }
 * }
 * ```
 * ### SqlDedicatedGatewayServiceCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.DocumentDB.Service("service", new()
 *     {
 *         AccountName = "ddb1",
 *         InstanceCount = 1,
 *         InstanceSize = "Cosmos.D4s",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "SqlDedicatedGateway",
 *         ServiceType = "SqlDedicatedGateway",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewService(ctx, "service", &documentdb.ServiceArgs{
 * 			AccountName:       pulumi.String("ddb1"),
 * 			InstanceCount:     pulumi.Int(1),
 * 			InstanceSize:      pulumi.String("Cosmos.D4s"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("SqlDedicatedGateway"),
 * 			ServiceType:       pulumi.String("SqlDedicatedGateway"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.Service;
 * import com.pulumi.azurenative.documentdb.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .accountName("ddb1")
 *             .instanceCount(1)
 *             .instanceSize("Cosmos.D4s")
 *             .resourceGroupName("rg1")
 *             .serviceName("SqlDedicatedGateway")
 *             .serviceType("SqlDedicatedGateway")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:Service SqlDedicatedGateway /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/services/{serviceName}
 * ```
 */
public class Service internal constructor(
    override val javaResource: com.pulumi.azurenative.documentdb.Service,
) : KotlinCustomResource(javaResource, ServiceMapper) {
    /**
     * The name of the database account.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Services response resource.
     */
    public val properties: Output<Any>
        get() = javaResource.properties().applyValue({ args0 -> args0 })

    /**
     * The type of Azure resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ServiceMapper : ResourceMapper<Service> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.documentdb.Service::class == javaResource::class

    override fun map(javaResource: Resource): Service = Service(
        javaResource as
            com.pulumi.azurenative.documentdb.Service,
    )
}

/**
 * @see [Service].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Service].
 */
public suspend fun service(name: String, block: suspend ServiceResourceBuilder.() -> Unit):
    Service {
    val builder = ServiceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Service].
 * @param name The _unique_ name of the resulting resource.
 */
public fun service(name: String): Service {
    val builder = ServiceResourceBuilder()
    builder.name(name)
    return builder.build()
}
