@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.azurenative.documentdb.SqlResourceSqlRoleDefinitionArgs.builder
import com.pulumi.azurenative.documentdb.kotlin.enums.RoleDefinitionType
import com.pulumi.azurenative.documentdb.kotlin.inputs.PermissionArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.PermissionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * An Azure Cosmos DB SQL Role Definition.
 * Azure REST API version: 2023-04-15. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * Other available API versions: 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview.
 * ## Example Usage
 * ### CosmosDBSqlRoleDefinitionCreateUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlResourceSqlRoleDefinition = new AzureNative.DocumentDB.SqlResourceSqlRoleDefinition("sqlResourceSqlRoleDefinition", new()
 *     {
 *         AccountName = "myAccountName",
 *         AssignableScopes = new[]
 *         {
 *             "/subscriptions/mySubscriptionId/resourceGroups/myResourceGroupName/providers/Microsoft.DocumentDB/databaseAccounts/myAccountName/dbs/sales",
 *             "/subscriptions/mySubscriptionId/resourceGroups/myResourceGroupName/providers/Microsoft.DocumentDB/databaseAccounts/myAccountName/dbs/purchases",
 *         },
 *         Permissions = new[]
 *         {
 *             new AzureNative.DocumentDB.Inputs.PermissionArgs
 *             {
 *                 DataActions = new[]
 *                 {
 *                     "Microsoft.DocumentDB/databaseAccounts/sqlDatabases/containers/items/create",
 *                     "Microsoft.DocumentDB/databaseAccounts/sqlDatabases/containers/items/read",
 *                 },
 *                 NotDataActions = new() { },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroupName",
 *         RoleDefinitionId = "myRoleDefinitionId",
 *         RoleName = "myRoleName",
 *         Type = AzureNative.DocumentDB.RoleDefinitionType.CustomRole,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewSqlResourceSqlRoleDefinition(ctx, "sqlResourceSqlRoleDefinition", &documentdb.SqlResourceSqlRoleDefinitionArgs{
 * 			AccountName: pulumi.String("myAccountName"),
 * 			AssignableScopes: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/mySubscriptionId/resourceGroups/myResourceGroupName/providers/Microsoft.DocumentDB/databaseAccounts/myAccountName/dbs/sales"),
 * 				pulumi.String("/subscriptions/mySubscriptionId/resourceGroups/myResourceGroupName/providers/Microsoft.DocumentDB/databaseAccounts/myAccountName/dbs/purchases"),
 * 			},
 * 			Permissions: []documentdb.PermissionArgs{
 * 				{
 * 					DataActions: pulumi.StringArray{
 * 						pulumi.String("Microsoft.DocumentDB/databaseAccounts/sqlDatabases/containers/items/create"),
 * 						pulumi.String("Microsoft.DocumentDB/databaseAccounts/sqlDatabases/containers/items/read"),
 * 					},
 * 					NotDataActions: pulumi.StringArray{},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroupName"),
 * 			RoleDefinitionId:  pulumi.String("myRoleDefinitionId"),
 * 			RoleName:          pulumi.String("myRoleName"),
 * 			Type:              documentdb.RoleDefinitionTypeCustomRole,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.SqlResourceSqlRoleDefinition;
 * import com.pulumi.azurenative.documentdb.SqlResourceSqlRoleDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlResourceSqlRoleDefinition = new SqlResourceSqlRoleDefinition("sqlResourceSqlRoleDefinition", SqlResourceSqlRoleDefinitionArgs.builder()
 *             .accountName("myAccountName")
 *             .assignableScopes(
 *                 "/subscriptions/mySubscriptionId/resourceGroups/myResourceGroupName/providers/Microsoft.DocumentDB/databaseAccounts/myAccountName/dbs/sales",
 *                 "/subscriptions/mySubscriptionId/resourceGroups/myResourceGroupName/providers/Microsoft.DocumentDB/databaseAccounts/myAccountName/dbs/purchases")
 *             .permissions(Map.ofEntries(
 *                 Map.entry("dataActions",
 *                     "Microsoft.DocumentDB/databaseAccounts/sqlDatabases/containers/items/create",
 *                     "Microsoft.DocumentDB/databaseAccounts/sqlDatabases/containers/items/read"),
 *                 Map.entry("notDataActions", )
 *             ))
 *             .resourceGroupName("myResourceGroupName")
 *             .roleDefinitionId("myRoleDefinitionId")
 *             .roleName("myRoleName")
 *             .type("CustomRole")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:SqlResourceSqlRoleDefinition myRoleDefinitionId /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlRoleDefinitions/{roleDefinitionId}
 * ```
 * @property accountName Cosmos DB database account name.
 * @property assignableScopes A set of fully qualified Scopes at or below which Role Assignments may be created using this Role Definition. This will allow application of this Role Definition on the entire database account or any underlying Database / Collection. Must have at least one element. Scopes higher than Database account are not enforceable as assignable Scopes. Note that resources referenced in assignable Scopes need not exist.
 * @property permissions The set of operations allowed through this Role Definition.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property roleDefinitionId The GUID for the Role Definition.
 * @property roleName A user-friendly name for the Role Definition. Must be unique for the database account.
 * @property type Indicates whether the Role Definition was built-in or user created.
 */
public data class SqlResourceSqlRoleDefinitionArgs(
    public val accountName: Output<String>? = null,
    public val assignableScopes: Output<List<String>>? = null,
    public val permissions: Output<List<PermissionArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val roleDefinitionId: Output<String>? = null,
    public val roleName: Output<String>? = null,
    public val type: Output<RoleDefinitionType>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.SqlResourceSqlRoleDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.SqlResourceSqlRoleDefinitionArgs =
        com.pulumi.azurenative.documentdb.SqlResourceSqlRoleDefinitionArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .assignableScopes(assignableScopes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .permissions(
                permissions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .roleDefinitionId(roleDefinitionId?.applyValue({ args0 -> args0 }))
            .roleName(roleName?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SqlResourceSqlRoleDefinitionArgs].
 */
@PulumiTagMarker
public class SqlResourceSqlRoleDefinitionArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var assignableScopes: Output<List<String>>? = null

    private var permissions: Output<List<PermissionArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var roleDefinitionId: Output<String>? = null

    private var roleName: Output<String>? = null

    private var type: Output<RoleDefinitionType>? = null

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("rwuhrtejjybegvss")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value A set of fully qualified Scopes at or below which Role Assignments may be created using this Role Definition. This will allow application of this Role Definition on the entire database account or any underlying Database / Collection. Must have at least one element. Scopes higher than Database account are not enforceable as assignable Scopes. Note that resources referenced in assignable Scopes need not exist.
     */
    @JvmName("nbrxfpweuprewngt")
    public suspend fun assignableScopes(`value`: Output<List<String>>) {
        this.assignableScopes = value
    }

    @JvmName("ooedrbkeiacsjucg")
    public suspend fun assignableScopes(vararg values: Output<String>) {
        this.assignableScopes = Output.all(values.asList())
    }

    /**
     * @param values A set of fully qualified Scopes at or below which Role Assignments may be created using this Role Definition. This will allow application of this Role Definition on the entire database account or any underlying Database / Collection. Must have at least one element. Scopes higher than Database account are not enforceable as assignable Scopes. Note that resources referenced in assignable Scopes need not exist.
     */
    @JvmName("dtkxmlemsykfltjv")
    public suspend fun assignableScopes(values: List<Output<String>>) {
        this.assignableScopes = Output.all(values)
    }

    /**
     * @param value The set of operations allowed through this Role Definition.
     */
    @JvmName("ykaskakjaylpsclp")
    public suspend fun permissions(`value`: Output<List<PermissionArgs>>) {
        this.permissions = value
    }

    @JvmName("lkahltsovnwdyjab")
    public suspend fun permissions(vararg values: Output<PermissionArgs>) {
        this.permissions = Output.all(values.asList())
    }

    /**
     * @param values The set of operations allowed through this Role Definition.
     */
    @JvmName("cyufraehqnidfaxr")
    public suspend fun permissions(values: List<Output<PermissionArgs>>) {
        this.permissions = Output.all(values)
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("iwkjplrkgcvnwhjj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The GUID for the Role Definition.
     */
    @JvmName("ntbqhvvfftqycmrb")
    public suspend fun roleDefinitionId(`value`: Output<String>) {
        this.roleDefinitionId = value
    }

    /**
     * @param value A user-friendly name for the Role Definition. Must be unique for the database account.
     */
    @JvmName("rotpkeqgldxkulsa")
    public suspend fun roleName(`value`: Output<String>) {
        this.roleName = value
    }

    /**
     * @param value Indicates whether the Role Definition was built-in or user created.
     */
    @JvmName("xjhugqgllbacvkmk")
    public suspend fun type(`value`: Output<RoleDefinitionType>) {
        this.type = value
    }

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("olpecuaffjddbcpj")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value A set of fully qualified Scopes at or below which Role Assignments may be created using this Role Definition. This will allow application of this Role Definition on the entire database account or any underlying Database / Collection. Must have at least one element. Scopes higher than Database account are not enforceable as assignable Scopes. Note that resources referenced in assignable Scopes need not exist.
     */
    @JvmName("nullrrkmxrxsoeit")
    public suspend fun assignableScopes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assignableScopes = mapped
    }

    /**
     * @param values A set of fully qualified Scopes at or below which Role Assignments may be created using this Role Definition. This will allow application of this Role Definition on the entire database account or any underlying Database / Collection. Must have at least one element. Scopes higher than Database account are not enforceable as assignable Scopes. Note that resources referenced in assignable Scopes need not exist.
     */
    @JvmName("gmtkjpvqbrsgtqrn")
    public suspend fun assignableScopes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.assignableScopes = mapped
    }

    /**
     * @param value The set of operations allowed through this Role Definition.
     */
    @JvmName("ohgmtmupsmdynqpe")
    public suspend fun permissions(`value`: List<PermissionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param argument The set of operations allowed through this Role Definition.
     */
    @JvmName("yftpfkjuyksxmdwj")
    public suspend fun permissions(argument: List<suspend PermissionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { PermissionArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param argument The set of operations allowed through this Role Definition.
     */
    @JvmName("xtjqmrqjwuyoswxb")
    public suspend fun permissions(vararg argument: suspend PermissionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { PermissionArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param argument The set of operations allowed through this Role Definition.
     */
    @JvmName("joyidribuucnbbav")
    public suspend fun permissions(argument: suspend PermissionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PermissionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param values The set of operations allowed through this Role Definition.
     */
    @JvmName("iwspnwqdpsajfjsj")
    public suspend fun permissions(vararg values: PermissionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lwrhndqhmqubwgoh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The GUID for the Role Definition.
     */
    @JvmName("tcssxoqefasaatuf")
    public suspend fun roleDefinitionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleDefinitionId = mapped
    }

    /**
     * @param value A user-friendly name for the Role Definition. Must be unique for the database account.
     */
    @JvmName("ysxvgyytsacgdtci")
    public suspend fun roleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleName = mapped
    }

    /**
     * @param value Indicates whether the Role Definition was built-in or user created.
     */
    @JvmName("qcvhnuceswuanoks")
    public suspend fun type(`value`: RoleDefinitionType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): SqlResourceSqlRoleDefinitionArgs = SqlResourceSqlRoleDefinitionArgs(
        accountName = accountName,
        assignableScopes = assignableScopes,
        permissions = permissions,
        resourceGroupName = resourceGroupName,
        roleDefinitionId = roleDefinitionId,
        roleName = roleName,
        type = type,
    )
}
