@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.azurenative.documentdb.SqlResourceSqlTriggerArgs.builder
import com.pulumi.azurenative.documentdb.kotlin.inputs.CreateUpdateOptionsArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.CreateUpdateOptionsArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.SqlTriggerResourceArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.SqlTriggerResourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An Azure Cosmos DB trigger.
 * Azure REST API version: 2023-04-15. Prior API version in Azure Native 1.x: 2021-03-15.
 * Other available API versions: 2019-08-01, 2023-03-15-preview, 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview.
 * ## Example Usage
 * ### CosmosDBSqlTriggerCreateUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlResourceSqlTrigger = new AzureNative.DocumentDB.SqlResourceSqlTrigger("sqlResourceSqlTrigger", new()
 *     {
 *         AccountName = "ddb1",
 *         ContainerName = "containerName",
 *         DatabaseName = "databaseName",
 *         Options = null,
 *         Resource = new AzureNative.DocumentDB.Inputs.SqlTriggerResourceArgs
 *         {
 *             Body = "body",
 *             Id = "triggerName",
 *             TriggerOperation = "triggerOperation",
 *             TriggerType = "triggerType",
 *         },
 *         ResourceGroupName = "rg1",
 *         TriggerName = "triggerName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewSqlResourceSqlTrigger(ctx, "sqlResourceSqlTrigger", &documentdb.SqlResourceSqlTriggerArgs{
 * 			AccountName:   pulumi.String("ddb1"),
 * 			ContainerName: pulumi.String("containerName"),
 * 			DatabaseName:  pulumi.String("databaseName"),
 * 			Options:       nil,
 * 			Resource: &documentdb.SqlTriggerResourceArgs{
 * 				Body:             pulumi.String("body"),
 * 				Id:               pulumi.String("triggerName"),
 * 				TriggerOperation: pulumi.String("triggerOperation"),
 * 				TriggerType:      pulumi.String("triggerType"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			TriggerName:       pulumi.String("triggerName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.SqlResourceSqlTrigger;
 * import com.pulumi.azurenative.documentdb.SqlResourceSqlTriggerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlResourceSqlTrigger = new SqlResourceSqlTrigger("sqlResourceSqlTrigger", SqlResourceSqlTriggerArgs.builder()
 *             .accountName("ddb1")
 *             .containerName("containerName")
 *             .databaseName("databaseName")
 *             .options()
 *             .resource(Map.ofEntries(
 *                 Map.entry("body", "body"),
 *                 Map.entry("id", "triggerName"),
 *                 Map.entry("triggerOperation", "triggerOperation"),
 *                 Map.entry("triggerType", "triggerType")
 *             ))
 *             .resourceGroupName("rg1")
 *             .triggerName("triggerName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:SqlResourceSqlTrigger triggerName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/triggers/{triggerName}
 * ```
 * @property accountName Cosmos DB database account name.
 * @property containerName Cosmos DB container name.
 * @property databaseName Cosmos DB database name.
 * @property location The location of the resource group to which the resource belongs.
 * @property options A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
 * @property resource The standard JSON format of a trigger
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
 * @property triggerName Cosmos DB trigger name.
 */
public data class SqlResourceSqlTriggerArgs(
    public val accountName: Output<String>? = null,
    public val containerName: Output<String>? = null,
    public val databaseName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val options: Output<CreateUpdateOptionsArgs>? = null,
    public val resource: Output<SqlTriggerResourceArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val triggerName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.SqlResourceSqlTriggerArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.SqlResourceSqlTriggerArgs =
        com.pulumi.azurenative.documentdb.SqlResourceSqlTriggerArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .containerName(containerName?.applyValue({ args0 -> args0 }))
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .options(options?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resource(resource?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .triggerName(triggerName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SqlResourceSqlTriggerArgs].
 */
@PulumiTagMarker
public class SqlResourceSqlTriggerArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var containerName: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var location: Output<String>? = null

    private var options: Output<CreateUpdateOptionsArgs>? = null

    private var resource: Output<SqlTriggerResourceArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var triggerName: Output<String>? = null

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("wpcfutcqayjyweki")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Cosmos DB container name.
     */
    @JvmName("byjapqdjjitiuomr")
    public suspend fun containerName(`value`: Output<String>) {
        this.containerName = value
    }

    /**
     * @param value Cosmos DB database name.
     */
    @JvmName("ithbhbymdnijkuya")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The location of the resource group to which the resource belongs.
     */
    @JvmName("qkaofxvqwdtgggrl")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
     */
    @JvmName("gtuigusgnibakfow")
    public suspend fun options(`value`: Output<CreateUpdateOptionsArgs>) {
        this.options = value
    }

    /**
     * @param value The standard JSON format of a trigger
     */
    @JvmName("swgakbxihyhrthen")
    public suspend fun resource(`value`: Output<SqlTriggerResourceArgs>) {
        this.resource = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("uelngtilpeehowwr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     */
    @JvmName("elhkprxjvlmptiui")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Cosmos DB trigger name.
     */
    @JvmName("muxhqchofdaijoxt")
    public suspend fun triggerName(`value`: Output<String>) {
        this.triggerName = value
    }

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("eaxukgicgvflpbkj")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Cosmos DB container name.
     */
    @JvmName("bxpghxyfxmuexnpb")
    public suspend fun containerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerName = mapped
    }

    /**
     * @param value Cosmos DB database name.
     */
    @JvmName("kvaprgvxjrwpcyfx")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The location of the resource group to which the resource belongs.
     */
    @JvmName("phjobhikkjfprdrx")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
     */
    @JvmName("rqdcohbivwfsfqnb")
    public suspend fun options(`value`: CreateUpdateOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.options = mapped
    }

    /**
     * @param argument A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
     */
    @JvmName("yaaqgdfauojigwqa")
    public suspend fun options(argument: suspend CreateUpdateOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = CreateUpdateOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.options = mapped
    }

    /**
     * @param value The standard JSON format of a trigger
     */
    @JvmName("lvoqigjsffgrrske")
    public suspend fun resource(`value`: SqlTriggerResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resource = mapped
    }

    /**
     * @param argument The standard JSON format of a trigger
     */
    @JvmName("rgslsdvxfqdkkqmf")
    public suspend fun resource(argument: suspend SqlTriggerResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SqlTriggerResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resource = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kkfcybofsegkqilx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     */
    @JvmName("ysoogfpxdsrdbgpg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     */
    @JvmName("pnybddcvcgikhujc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Cosmos DB trigger name.
     */
    @JvmName("ghrrmiayawhbvmxd")
    public suspend fun triggerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.triggerName = mapped
    }

    internal fun build(): SqlResourceSqlTriggerArgs = SqlResourceSqlTriggerArgs(
        accountName = accountName,
        containerName = containerName,
        databaseName = databaseName,
        location = location,
        options = options,
        resource = resource,
        resourceGroupName = resourceGroupName,
        tags = tags,
        triggerName = triggerName,
    )
}
