@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.azurenative.documentdb.SqlResourceSqlUserDefinedFunctionArgs.builder
import com.pulumi.azurenative.documentdb.kotlin.inputs.CreateUpdateOptionsArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.CreateUpdateOptionsArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.SqlUserDefinedFunctionResourceArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.SqlUserDefinedFunctionResourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An Azure Cosmos DB userDefinedFunction.
 * Azure REST API version: 2023-04-15. Prior API version in Azure Native 1.x: 2021-03-15.
 * Other available API versions: 2019-08-01, 2023-03-15-preview, 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview.
 * ## Example Usage
 * ### CosmosDBSqlUserDefinedFunctionCreateUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlResourceSqlUserDefinedFunction = new AzureNative.DocumentDB.SqlResourceSqlUserDefinedFunction("sqlResourceSqlUserDefinedFunction", new()
 *     {
 *         AccountName = "ddb1",
 *         ContainerName = "containerName",
 *         DatabaseName = "databaseName",
 *         Options = null,
 *         Resource = new AzureNative.DocumentDB.Inputs.SqlUserDefinedFunctionResourceArgs
 *         {
 *             Body = "body",
 *             Id = "userDefinedFunctionName",
 *         },
 *         ResourceGroupName = "rg1",
 *         UserDefinedFunctionName = "userDefinedFunctionName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewSqlResourceSqlUserDefinedFunction(ctx, "sqlResourceSqlUserDefinedFunction", &documentdb.SqlResourceSqlUserDefinedFunctionArgs{
 * 			AccountName:   pulumi.String("ddb1"),
 * 			ContainerName: pulumi.String("containerName"),
 * 			DatabaseName:  pulumi.String("databaseName"),
 * 			Options:       nil,
 * 			Resource: &documentdb.SqlUserDefinedFunctionResourceArgs{
 * 				Body: pulumi.String("body"),
 * 				Id:   pulumi.String("userDefinedFunctionName"),
 * 			},
 * 			ResourceGroupName:       pulumi.String("rg1"),
 * 			UserDefinedFunctionName: pulumi.String("userDefinedFunctionName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.SqlResourceSqlUserDefinedFunction;
 * import com.pulumi.azurenative.documentdb.SqlResourceSqlUserDefinedFunctionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlResourceSqlUserDefinedFunction = new SqlResourceSqlUserDefinedFunction("sqlResourceSqlUserDefinedFunction", SqlResourceSqlUserDefinedFunctionArgs.builder()
 *             .accountName("ddb1")
 *             .containerName("containerName")
 *             .databaseName("databaseName")
 *             .options()
 *             .resource(Map.ofEntries(
 *                 Map.entry("body", "body"),
 *                 Map.entry("id", "userDefinedFunctionName")
 *             ))
 *             .resourceGroupName("rg1")
 *             .userDefinedFunctionName("userDefinedFunctionName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:SqlResourceSqlUserDefinedFunction userDefinedFunctionName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/userDefinedFunctions/{userDefinedFunctionName}
 * ```
 * @property accountName Cosmos DB database account name.
 * @property containerName Cosmos DB container name.
 * @property databaseName Cosmos DB database name.
 * @property location The location of the resource group to which the resource belongs.
 * @property options A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
 * @property resource The standard JSON format of a userDefinedFunction
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
 * @property userDefinedFunctionName Cosmos DB userDefinedFunction name.
 */
public data class SqlResourceSqlUserDefinedFunctionArgs(
    public val accountName: Output<String>? = null,
    public val containerName: Output<String>? = null,
    public val databaseName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val options: Output<CreateUpdateOptionsArgs>? = null,
    public val resource: Output<SqlUserDefinedFunctionResourceArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userDefinedFunctionName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.SqlResourceSqlUserDefinedFunctionArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.SqlResourceSqlUserDefinedFunctionArgs =
        com.pulumi.azurenative.documentdb.SqlResourceSqlUserDefinedFunctionArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .containerName(containerName?.applyValue({ args0 -> args0 }))
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .options(options?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resource(resource?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userDefinedFunctionName(userDefinedFunctionName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SqlResourceSqlUserDefinedFunctionArgs].
 */
@PulumiTagMarker
public class SqlResourceSqlUserDefinedFunctionArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var containerName: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var location: Output<String>? = null

    private var options: Output<CreateUpdateOptionsArgs>? = null

    private var resource: Output<SqlUserDefinedFunctionResourceArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userDefinedFunctionName: Output<String>? = null

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("avbxbxgjxdehwqlj")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Cosmos DB container name.
     */
    @JvmName("dbnuxqyobtajxirb")
    public suspend fun containerName(`value`: Output<String>) {
        this.containerName = value
    }

    /**
     * @param value Cosmos DB database name.
     */
    @JvmName("epmsfwwktffxnrdb")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The location of the resource group to which the resource belongs.
     */
    @JvmName("nhxixckxnuporoxt")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
     */
    @JvmName("xtujwyhisospdbcr")
    public suspend fun options(`value`: Output<CreateUpdateOptionsArgs>) {
        this.options = value
    }

    /**
     * @param value The standard JSON format of a userDefinedFunction
     */
    @JvmName("soopfsmnccxnyuyr")
    public suspend fun resource(`value`: Output<SqlUserDefinedFunctionResourceArgs>) {
        this.resource = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vvobbcfnukvpsldd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     */
    @JvmName("ljrumlkdvtnnatox")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Cosmos DB userDefinedFunction name.
     */
    @JvmName("hryfslxiivfnqmuv")
    public suspend fun userDefinedFunctionName(`value`: Output<String>) {
        this.userDefinedFunctionName = value
    }

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("pjaronbtjhuovalx")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Cosmos DB container name.
     */
    @JvmName("vejicfcdiclqroxp")
    public suspend fun containerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerName = mapped
    }

    /**
     * @param value Cosmos DB database name.
     */
    @JvmName("ebgmajdrplpvstfa")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The location of the resource group to which the resource belongs.
     */
    @JvmName("wcpjkunmrdrsmjjd")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
     */
    @JvmName("epwreilhprnhfqvs")
    public suspend fun options(`value`: CreateUpdateOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.options = mapped
    }

    /**
     * @param argument A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
     */
    @JvmName("xetfjjbrvvdujfoc")
    public suspend fun options(argument: suspend CreateUpdateOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = CreateUpdateOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.options = mapped
    }

    /**
     * @param value The standard JSON format of a userDefinedFunction
     */
    @JvmName("feqwyjchiwketnja")
    public suspend fun resource(`value`: SqlUserDefinedFunctionResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resource = mapped
    }

    /**
     * @param argument The standard JSON format of a userDefinedFunction
     */
    @JvmName("koastrgsbopiisja")
    public suspend
    fun resource(argument: suspend SqlUserDefinedFunctionResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SqlUserDefinedFunctionResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resource = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("edhrccjwdfcfpule")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     */
    @JvmName("ssqnkqelbaaevvqg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     */
    @JvmName("wycaoutgdsoidtfr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Cosmos DB userDefinedFunction name.
     */
    @JvmName("hrmrxornoiocaxjv")
    public suspend fun userDefinedFunctionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userDefinedFunctionName = mapped
    }

    internal fun build(): SqlResourceSqlUserDefinedFunctionArgs =
        SqlResourceSqlUserDefinedFunctionArgs(
            accountName = accountName,
            containerName = containerName,
            databaseName = databaseName,
            location = location,
            options = options,
            resource = resource,
            resourceGroupName = resourceGroupName,
            tags = tags,
            userDefinedFunctionName = userDefinedFunctionName,
        )
}
