@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.azurenative.documentdb.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.documentdb.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ThroughputPool].
 */
@PulumiTagMarker
public class ThroughputPoolResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ThroughputPoolArgs = ThroughputPoolArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ThroughputPoolArgsBuilder.() -> Unit) {
        val builder = ThroughputPoolArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ThroughputPool {
        val builtJavaResource =
            com.pulumi.azurenative.documentdb.ThroughputPool(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ThroughputPool(builtJavaResource)
    }
}

/**
 * An Azure Cosmos DB Throughputpool.
 * Azure REST API version: 2023-11-15-preview.
 * ## Example Usage
 * ### CosmosDB ThroughputPool Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var throughputPool = new AzureNative.DocumentDB.ThroughputPool("throughputPool", new()
 *     {
 *         Location = "westus2",
 *         MaxThroughput = 10000,
 *         ResourceGroupName = "rg1",
 *         Tags = null,
 *         ThroughputPoolName = "tp1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewThroughputPool(ctx, "throughputPool", &documentdb.ThroughputPoolArgs{
 * 			Location:           pulumi.String("westus2"),
 * 			MaxThroughput:      pulumi.Int(10000),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			Tags:               nil,
 * 			ThroughputPoolName: pulumi.String("tp1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.ThroughputPool;
 * import com.pulumi.azurenative.documentdb.ThroughputPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var throughputPool = new ThroughputPool("throughputPool", ThroughputPoolArgs.builder()
 *             .location("westus2")
 *             .maxThroughput(10000)
 *             .resourceGroupName("rg1")
 *             .tags()
 *             .throughputPoolName("tp1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:ThroughputPool tp1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/throughputPools/{throughputPoolName}
 * ```
 */
public class ThroughputPool internal constructor(
    override val javaResource: com.pulumi.azurenative.documentdb.ThroughputPool,
) : KotlinCustomResource(javaResource, ThroughputPoolMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Value for throughput to be shared among CosmosDB resources in the pool.
     */
    public val maxThroughput: Output<Int>?
        get() = javaResource.maxThroughput().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A provisioning state of the ThroughputPool.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ThroughputPoolMapper : ResourceMapper<ThroughputPool> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.documentdb.ThroughputPool::class == javaResource::class

    override fun map(javaResource: Resource): ThroughputPool = ThroughputPool(
        javaResource as
            com.pulumi.azurenative.documentdb.ThroughputPool,
    )
}

/**
 * @see [ThroughputPool].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ThroughputPool].
 */
public suspend fun throughputPool(
    name: String,
    block: suspend ThroughputPoolResourceBuilder.() -> Unit,
): ThroughputPool {
    val builder = ThroughputPoolResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ThroughputPool].
 * @param name The _unique_ name of the resulting resource.
 */
public fun throughputPool(name: String): ThroughputPool {
    val builder = ThroughputPoolResourceBuilder()
    builder.name(name)
    return builder.build()
}
