@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Whether requests from Public Network are allowed
 */
public enum class PublicNetworkAccess(
    public val javaValue: com.pulumi.azurenative.documentdb.enums.PublicNetworkAccess,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.enums.PublicNetworkAccess> {
    Enabled(com.pulumi.azurenative.documentdb.enums.PublicNetworkAccess.Enabled),
    Disabled(com.pulumi.azurenative.documentdb.enums.PublicNetworkAccess.Disabled),
    SecuredByPerimeter(com.pulumi.azurenative.documentdb.enums.PublicNetworkAccess.SecuredByPerimeter),
    ;

    override fun toJava(): com.pulumi.azurenative.documentdb.enums.PublicNetworkAccess = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.enums.PublicNetworkAccess):
            PublicNetworkAccess = PublicNetworkAccess.values().first { it.javaValue == javaType }
    }
}
