@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of identity used for the resource. The type 'SystemAssigned,UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the service.
 */
public enum class ResourceIdentityType(
    public val javaValue: com.pulumi.azurenative.documentdb.enums.ResourceIdentityType,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.enums.ResourceIdentityType> {
    SystemAssigned(com.pulumi.azurenative.documentdb.enums.ResourceIdentityType.SystemAssigned),
    UserAssigned(com.pulumi.azurenative.documentdb.enums.ResourceIdentityType.UserAssigned),
    SystemAssigned_UserAssigned(com.pulumi.azurenative.documentdb.enums.ResourceIdentityType.SystemAssigned_UserAssigned),
    None(com.pulumi.azurenative.documentdb.enums.ResourceIdentityType.None),
    ;

    override fun toJava(): com.pulumi.azurenative.documentdb.enums.ResourceIdentityType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.enums.ResourceIdentityType):
            ResourceIdentityType = ResourceIdentityType.values().first { it.javaValue == javaType }
    }
}
