@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.CapabilityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Cosmos DB capability object
 * @property name Name of the Cosmos DB capability. For example, "name": "EnableCassandra". Current values also include "EnableTable" and "EnableGremlin".
 */
public data class CapabilityArgs(
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.CapabilityArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.CapabilityArgs =
        com.pulumi.azurenative.documentdb.inputs.CapabilityArgs.builder()
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CapabilityArgs].
 */
@PulumiTagMarker
public class CapabilityArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value Name of the Cosmos DB capability. For example, "name": "EnableCassandra". Current values also include "EnableTable" and "EnableGremlin".
     */
    @JvmName("umgmqwqukdnfvmkq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the Cosmos DB capability. For example, "name": "EnableCassandra". Current values also include "EnableTable" and "EnableGremlin".
     */
    @JvmName("plyeublvlkhomnon")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): CapabilityArgs = CapabilityArgs(
        name = name,
    )
}
