@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.CertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property pem PEM formatted public key.
 */
public data class CertificateArgs(
    public val pem: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.CertificateArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.CertificateArgs =
        com.pulumi.azurenative.documentdb.inputs.CertificateArgs.builder()
            .pem(pem?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CertificateArgs].
 */
@PulumiTagMarker
public class CertificateArgsBuilder internal constructor() {
    private var pem: Output<String>? = null

    /**
     * @param value PEM formatted public key.
     */
    @JvmName("giwjyyuvhytniajb")
    public suspend fun pem(`value`: Output<String>) {
        this.pem = value
    }

    /**
     * @param value PEM formatted public key.
     */
    @JvmName("kdcpnkufiaousfjg")
    public suspend fun pem(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pem = mapped
    }

    internal fun build(): CertificateArgs = CertificateArgs(
        pem = pem,
    )
}
