@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.ClusterResourcePropertiesArgs.builder
import com.pulumi.azurenative.documentdb.kotlin.enums.AuthenticationMethod
import com.pulumi.azurenative.documentdb.kotlin.enums.ManagedCassandraProvisioningState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Properties of a managed Cassandra cluster.
 * @property authenticationMethod Which authentication method Cassandra should use to authenticate clients. 'None' turns off authentication, so should not be used except in emergencies. 'Cassandra' is the default password based authentication. The default is 'Cassandra'.
 * @property cassandraAuditLoggingEnabled Whether Cassandra audit logging is enabled
 * @property cassandraVersion Which version of Cassandra should this cluster converge to running (e.g., 3.11). When updated, the cluster may take some time to migrate to the new version.
 * @property clientCertificates List of TLS certificates used to authorize clients connecting to the cluster. All connections are TLS encrypted whether clientCertificates is set or not, but if clientCertificates is set, the managed Cassandra cluster will reject all connections not bearing a TLS client certificate that can be validated from one or more of the public certificates in this property.
 * @property clusterNameOverride If you need to set the clusterName property in cassandra.yaml to something besides the resource name of the cluster, set the value to use on this property.
 * @property deallocated Whether the cluster and associated data centers has been deallocated.
 * @property delegatedManagementSubnetId Resource id of a subnet that this cluster's management service should have its network interface attached to. The subnet must be routable to all subnets that will be delegated to data centers. The resource id must be of the form '/subscriptions/<subscription id>/resourceGroups/<resource group>/providers/Microsoft.Network/virtualNetworks/<virtual network>/subnets/<subnet>'
 * @property externalGossipCertificates List of TLS certificates used to authorize gossip from unmanaged data centers. The TLS certificates of all nodes in unmanaged data centers must be verifiable using one of the certificates provided in this property.
 * @property externalSeedNodes List of IP addresses of seed nodes in unmanaged data centers. These will be added to the seed node lists of all managed nodes.
 * @property hoursBetweenBackups (Deprecated) Number of hours to wait between taking a backup of the cluster.
 * @property initialCassandraAdminPassword Initial password for clients connecting as admin to the cluster. Should be changed after cluster creation. Returns null on GET. This field only applies when the authenticationMethod field is 'Cassandra'.
 * @property prometheusEndpoint Hostname or IP address where the Prometheus endpoint containing data about the managed Cassandra nodes can be reached.
 * @property provisionError Error related to resource provisioning.
 * @property provisioningState The status of the resource at the time the operation was called.
 * @property repairEnabled Should automatic repairs run on this cluster? If omitted, this is true, and should stay true unless you are running a hybrid cluster where you are already doing your own repairs.
 * @property restoreFromBackupId To create an empty cluster, omit this field or set it to null. To restore a backup into a new cluster, set this field to the resource id of the backup.
 */
public data class ClusterResourcePropertiesArgs(
    public val authenticationMethod: Output<Either<String, AuthenticationMethod>>? = null,
    public val cassandraAuditLoggingEnabled: Output<Boolean>? = null,
    public val cassandraVersion: Output<String>? = null,
    public val clientCertificates: Output<List<CertificateArgs>>? = null,
    public val clusterNameOverride: Output<String>? = null,
    public val deallocated: Output<Boolean>? = null,
    public val delegatedManagementSubnetId: Output<String>? = null,
    public val externalGossipCertificates: Output<List<CertificateArgs>>? = null,
    public val externalSeedNodes: Output<List<SeedNodeArgs>>? = null,
    public val hoursBetweenBackups: Output<Int>? = null,
    public val initialCassandraAdminPassword: Output<String>? = null,
    public val prometheusEndpoint: Output<SeedNodeArgs>? = null,
    public val provisionError: Output<CassandraErrorArgs>? = null,
    public val provisioningState: Output<Either<String, ManagedCassandraProvisioningState>>? = null,
    public val repairEnabled: Output<Boolean>? = null,
    public val restoreFromBackupId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.ClusterResourcePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.ClusterResourcePropertiesArgs =
        com.pulumi.azurenative.documentdb.inputs.ClusterResourcePropertiesArgs.builder()
            .authenticationMethod(
                authenticationMethod?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .cassandraAuditLoggingEnabled(cassandraAuditLoggingEnabled?.applyValue({ args0 -> args0 }))
            .cassandraVersion(cassandraVersion?.applyValue({ args0 -> args0 }))
            .clientCertificates(
                clientCertificates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .clusterNameOverride(clusterNameOverride?.applyValue({ args0 -> args0 }))
            .deallocated(deallocated?.applyValue({ args0 -> args0 }))
            .delegatedManagementSubnetId(delegatedManagementSubnetId?.applyValue({ args0 -> args0 }))
            .externalGossipCertificates(
                externalGossipCertificates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .externalSeedNodes(
                externalSeedNodes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .hoursBetweenBackups(hoursBetweenBackups?.applyValue({ args0 -> args0 }))
            .initialCassandraAdminPassword(initialCassandraAdminPassword?.applyValue({ args0 -> args0 }))
            .prometheusEndpoint(
                prometheusEndpoint?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .provisionError(provisionError?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .repairEnabled(repairEnabled?.applyValue({ args0 -> args0 }))
            .restoreFromBackupId(restoreFromBackupId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterResourcePropertiesArgs].
 */
@PulumiTagMarker
public class ClusterResourcePropertiesArgsBuilder internal constructor() {
    private var authenticationMethod: Output<Either<String, AuthenticationMethod>>? = null

    private var cassandraAuditLoggingEnabled: Output<Boolean>? = null

    private var cassandraVersion: Output<String>? = null

    private var clientCertificates: Output<List<CertificateArgs>>? = null

    private var clusterNameOverride: Output<String>? = null

    private var deallocated: Output<Boolean>? = null

    private var delegatedManagementSubnetId: Output<String>? = null

    private var externalGossipCertificates: Output<List<CertificateArgs>>? = null

    private var externalSeedNodes: Output<List<SeedNodeArgs>>? = null

    private var hoursBetweenBackups: Output<Int>? = null

    private var initialCassandraAdminPassword: Output<String>? = null

    private var prometheusEndpoint: Output<SeedNodeArgs>? = null

    private var provisionError: Output<CassandraErrorArgs>? = null

    private var provisioningState: Output<Either<String, ManagedCassandraProvisioningState>>? = null

    private var repairEnabled: Output<Boolean>? = null

    private var restoreFromBackupId: Output<String>? = null

    /**
     * @param value Which authentication method Cassandra should use to authenticate clients. 'None' turns off authentication, so should not be used except in emergencies. 'Cassandra' is the default password based authentication. The default is 'Cassandra'.
     */
    @JvmName("gjpukxwolsguvyyc")
    public suspend fun authenticationMethod(`value`: Output<Either<String, AuthenticationMethod>>) {
        this.authenticationMethod = value
    }

    /**
     * @param value Whether Cassandra audit logging is enabled
     */
    @JvmName("ciakqrmfulbnyqvd")
    public suspend fun cassandraAuditLoggingEnabled(`value`: Output<Boolean>) {
        this.cassandraAuditLoggingEnabled = value
    }

    /**
     * @param value Which version of Cassandra should this cluster converge to running (e.g., 3.11). When updated, the cluster may take some time to migrate to the new version.
     */
    @JvmName("dckmbvbtiuevlfbj")
    public suspend fun cassandraVersion(`value`: Output<String>) {
        this.cassandraVersion = value
    }

    /**
     * @param value List of TLS certificates used to authorize clients connecting to the cluster. All connections are TLS encrypted whether clientCertificates is set or not, but if clientCertificates is set, the managed Cassandra cluster will reject all connections not bearing a TLS client certificate that can be validated from one or more of the public certificates in this property.
     */
    @JvmName("fvxcngfvjfakscuc")
    public suspend fun clientCertificates(`value`: Output<List<CertificateArgs>>) {
        this.clientCertificates = value
    }

    @JvmName("gkrwwvbgbyjlnakd")
    public suspend fun clientCertificates(vararg values: Output<CertificateArgs>) {
        this.clientCertificates = Output.all(values.asList())
    }

    /**
     * @param values List of TLS certificates used to authorize clients connecting to the cluster. All connections are TLS encrypted whether clientCertificates is set or not, but if clientCertificates is set, the managed Cassandra cluster will reject all connections not bearing a TLS client certificate that can be validated from one or more of the public certificates in this property.
     */
    @JvmName("unyddixufrlquktc")
    public suspend fun clientCertificates(values: List<Output<CertificateArgs>>) {
        this.clientCertificates = Output.all(values)
    }

    /**
     * @param value If you need to set the clusterName property in cassandra.yaml to something besides the resource name of the cluster, set the value to use on this property.
     */
    @JvmName("fkebqwvahowkgqma")
    public suspend fun clusterNameOverride(`value`: Output<String>) {
        this.clusterNameOverride = value
    }

    /**
     * @param value Whether the cluster and associated data centers has been deallocated.
     */
    @JvmName("tsoiednbscapoqko")
    public suspend fun deallocated(`value`: Output<Boolean>) {
        this.deallocated = value
    }

    /**
     * @param value Resource id of a subnet that this cluster's management service should have its network interface attached to. The subnet must be routable to all subnets that will be delegated to data centers. The resource id must be of the form '/subscriptions/<subscription id>/resourceGroups/<resource group>/providers/Microsoft.Network/virtualNetworks/<virtual network>/subnets/<subnet>'
     */
    @JvmName("aqnbmdbskxrqvgob")
    public suspend fun delegatedManagementSubnetId(`value`: Output<String>) {
        this.delegatedManagementSubnetId = value
    }

    /**
     * @param value List of TLS certificates used to authorize gossip from unmanaged data centers. The TLS certificates of all nodes in unmanaged data centers must be verifiable using one of the certificates provided in this property.
     */
    @JvmName("sbmcopyffdkmjcde")
    public suspend fun externalGossipCertificates(`value`: Output<List<CertificateArgs>>) {
        this.externalGossipCertificates = value
    }

    @JvmName("ewfwtqydwxbrkkbf")
    public suspend fun externalGossipCertificates(vararg values: Output<CertificateArgs>) {
        this.externalGossipCertificates = Output.all(values.asList())
    }

    /**
     * @param values List of TLS certificates used to authorize gossip from unmanaged data centers. The TLS certificates of all nodes in unmanaged data centers must be verifiable using one of the certificates provided in this property.
     */
    @JvmName("sdqshmhaintpnuft")
    public suspend fun externalGossipCertificates(values: List<Output<CertificateArgs>>) {
        this.externalGossipCertificates = Output.all(values)
    }

    /**
     * @param value List of IP addresses of seed nodes in unmanaged data centers. These will be added to the seed node lists of all managed nodes.
     */
    @JvmName("cwxsfbjamofbnjvn")
    public suspend fun externalSeedNodes(`value`: Output<List<SeedNodeArgs>>) {
        this.externalSeedNodes = value
    }

    @JvmName("dowvxpkxgbydklpl")
    public suspend fun externalSeedNodes(vararg values: Output<SeedNodeArgs>) {
        this.externalSeedNodes = Output.all(values.asList())
    }

    /**
     * @param values List of IP addresses of seed nodes in unmanaged data centers. These will be added to the seed node lists of all managed nodes.
     */
    @JvmName("prlhqhjxthnuxgkw")
    public suspend fun externalSeedNodes(values: List<Output<SeedNodeArgs>>) {
        this.externalSeedNodes = Output.all(values)
    }

    /**
     * @param value (Deprecated) Number of hours to wait between taking a backup of the cluster.
     */
    @JvmName("iibqvjrkcwcntmmc")
    public suspend fun hoursBetweenBackups(`value`: Output<Int>) {
        this.hoursBetweenBackups = value
    }

    /**
     * @param value Initial password for clients connecting as admin to the cluster. Should be changed after cluster creation. Returns null on GET. This field only applies when the authenticationMethod field is 'Cassandra'.
     */
    @JvmName("yanutesictbpfffi")
    public suspend fun initialCassandraAdminPassword(`value`: Output<String>) {
        this.initialCassandraAdminPassword = value
    }

    /**
     * @param value Hostname or IP address where the Prometheus endpoint containing data about the managed Cassandra nodes can be reached.
     */
    @JvmName("ufevaedlegyapyqp")
    public suspend fun prometheusEndpoint(`value`: Output<SeedNodeArgs>) {
        this.prometheusEndpoint = value
    }

    /**
     * @param value Error related to resource provisioning.
     */
    @JvmName("fxahnfaxdvfaxjcd")
    public suspend fun provisionError(`value`: Output<CassandraErrorArgs>) {
        this.provisionError = value
    }

    /**
     * @param value The status of the resource at the time the operation was called.
     */
    @JvmName("roicfsusnuberbqu")
    public suspend
    fun provisioningState(`value`: Output<Either<String, ManagedCassandraProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value Should automatic repairs run on this cluster? If omitted, this is true, and should stay true unless you are running a hybrid cluster where you are already doing your own repairs.
     */
    @JvmName("hwwshwycmrgehmhh")
    public suspend fun repairEnabled(`value`: Output<Boolean>) {
        this.repairEnabled = value
    }

    /**
     * @param value To create an empty cluster, omit this field or set it to null. To restore a backup into a new cluster, set this field to the resource id of the backup.
     */
    @JvmName("gaaqlvtqugfrcwal")
    public suspend fun restoreFromBackupId(`value`: Output<String>) {
        this.restoreFromBackupId = value
    }

    /**
     * @param value Which authentication method Cassandra should use to authenticate clients. 'None' turns off authentication, so should not be used except in emergencies. 'Cassandra' is the default password based authentication. The default is 'Cassandra'.
     */
    @JvmName("ryvcknmylyurqivi")
    public suspend fun authenticationMethod(`value`: Either<String, AuthenticationMethod>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationMethod = mapped
    }

    /**
     * @param value Which authentication method Cassandra should use to authenticate clients. 'None' turns off authentication, so should not be used except in emergencies. 'Cassandra' is the default password based authentication. The default is 'Cassandra'.
     */
    @JvmName("tfhmiwrlmjyohlft")
    public fun authenticationMethod(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AuthenticationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationMethod = mapped
    }

    /**
     * @param value Which authentication method Cassandra should use to authenticate clients. 'None' turns off authentication, so should not be used except in emergencies. 'Cassandra' is the default password based authentication. The default is 'Cassandra'.
     */
    @JvmName("uxdsyoneaekibxyj")
    public fun authenticationMethod(`value`: AuthenticationMethod) {
        val toBeMapped = Either.ofRight<String, AuthenticationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationMethod = mapped
    }

    /**
     * @param value Whether Cassandra audit logging is enabled
     */
    @JvmName("uidksjcagjyshxjf")
    public suspend fun cassandraAuditLoggingEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cassandraAuditLoggingEnabled = mapped
    }

    /**
     * @param value Which version of Cassandra should this cluster converge to running (e.g., 3.11). When updated, the cluster may take some time to migrate to the new version.
     */
    @JvmName("kshxbkvgxvryjkab")
    public suspend fun cassandraVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cassandraVersion = mapped
    }

    /**
     * @param value List of TLS certificates used to authorize clients connecting to the cluster. All connections are TLS encrypted whether clientCertificates is set or not, but if clientCertificates is set, the managed Cassandra cluster will reject all connections not bearing a TLS client certificate that can be validated from one or more of the public certificates in this property.
     */
    @JvmName("migpnejiwevxulki")
    public suspend fun clientCertificates(`value`: List<CertificateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCertificates = mapped
    }

    /**
     * @param argument List of TLS certificates used to authorize clients connecting to the cluster. All connections are TLS encrypted whether clientCertificates is set or not, but if clientCertificates is set, the managed Cassandra cluster will reject all connections not bearing a TLS client certificate that can be validated from one or more of the public certificates in this property.
     */
    @JvmName("jqtkyjuhirmmakub")
    public suspend fun clientCertificates(argument: List<suspend CertificateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { CertificateArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.clientCertificates = mapped
    }

    /**
     * @param argument List of TLS certificates used to authorize clients connecting to the cluster. All connections are TLS encrypted whether clientCertificates is set or not, but if clientCertificates is set, the managed Cassandra cluster will reject all connections not bearing a TLS client certificate that can be validated from one or more of the public certificates in this property.
     */
    @JvmName("wquvlfiwmwdrdani")
    public suspend fun clientCertificates(
        vararg
        argument: suspend CertificateArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map { CertificateArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.clientCertificates = mapped
    }

    /**
     * @param argument List of TLS certificates used to authorize clients connecting to the cluster. All connections are TLS encrypted whether clientCertificates is set or not, but if clientCertificates is set, the managed Cassandra cluster will reject all connections not bearing a TLS client certificate that can be validated from one or more of the public certificates in this property.
     */
    @JvmName("vmefekdgolemspfe")
    public suspend fun clientCertificates(argument: suspend CertificateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CertificateArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.clientCertificates = mapped
    }

    /**
     * @param values List of TLS certificates used to authorize clients connecting to the cluster. All connections are TLS encrypted whether clientCertificates is set or not, but if clientCertificates is set, the managed Cassandra cluster will reject all connections not bearing a TLS client certificate that can be validated from one or more of the public certificates in this property.
     */
    @JvmName("vlokaplndmrxgbep")
    public suspend fun clientCertificates(vararg values: CertificateArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientCertificates = mapped
    }

    /**
     * @param value If you need to set the clusterName property in cassandra.yaml to something besides the resource name of the cluster, set the value to use on this property.
     */
    @JvmName("ahkcyvicewkgpfdn")
    public suspend fun clusterNameOverride(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterNameOverride = mapped
    }

    /**
     * @param value Whether the cluster and associated data centers has been deallocated.
     */
    @JvmName("yvxcrcxrgclrdtdu")
    public suspend fun deallocated(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deallocated = mapped
    }

    /**
     * @param value Resource id of a subnet that this cluster's management service should have its network interface attached to. The subnet must be routable to all subnets that will be delegated to data centers. The resource id must be of the form '/subscriptions/<subscription id>/resourceGroups/<resource group>/providers/Microsoft.Network/virtualNetworks/<virtual network>/subnets/<subnet>'
     */
    @JvmName("qmqntqgiavvtshpx")
    public suspend fun delegatedManagementSubnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delegatedManagementSubnetId = mapped
    }

    /**
     * @param value List of TLS certificates used to authorize gossip from unmanaged data centers. The TLS certificates of all nodes in unmanaged data centers must be verifiable using one of the certificates provided in this property.
     */
    @JvmName("qenkjdsxofftdchv")
    public suspend fun externalGossipCertificates(`value`: List<CertificateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalGossipCertificates = mapped
    }

    /**
     * @param argument List of TLS certificates used to authorize gossip from unmanaged data centers. The TLS certificates of all nodes in unmanaged data centers must be verifiable using one of the certificates provided in this property.
     */
    @JvmName("ojouavyaafxifaeh")
    public suspend
    fun externalGossipCertificates(argument: List<suspend CertificateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { CertificateArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.externalGossipCertificates = mapped
    }

    /**
     * @param argument List of TLS certificates used to authorize gossip from unmanaged data centers. The TLS certificates of all nodes in unmanaged data centers must be verifiable using one of the certificates provided in this property.
     */
    @JvmName("nggrhexlfndchwxw")
    public suspend fun externalGossipCertificates(
        vararg
        argument: suspend CertificateArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map { CertificateArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.externalGossipCertificates = mapped
    }

    /**
     * @param argument List of TLS certificates used to authorize gossip from unmanaged data centers. The TLS certificates of all nodes in unmanaged data centers must be verifiable using one of the certificates provided in this property.
     */
    @JvmName("ktseahqkvgmsfkeo")
    public suspend
    fun externalGossipCertificates(argument: suspend CertificateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CertificateArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.externalGossipCertificates = mapped
    }

    /**
     * @param values List of TLS certificates used to authorize gossip from unmanaged data centers. The TLS certificates of all nodes in unmanaged data centers must be verifiable using one of the certificates provided in this property.
     */
    @JvmName("ilsiuprpddbbdswf")
    public suspend fun externalGossipCertificates(vararg values: CertificateArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.externalGossipCertificates = mapped
    }

    /**
     * @param value List of IP addresses of seed nodes in unmanaged data centers. These will be added to the seed node lists of all managed nodes.
     */
    @JvmName("dyckgnojtvogepug")
    public suspend fun externalSeedNodes(`value`: List<SeedNodeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalSeedNodes = mapped
    }

    /**
     * @param argument List of IP addresses of seed nodes in unmanaged data centers. These will be added to the seed node lists of all managed nodes.
     */
    @JvmName("yvymsfgpgdqoulcc")
    public suspend fun externalSeedNodes(argument: List<suspend SeedNodeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SeedNodeArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.externalSeedNodes = mapped
    }

    /**
     * @param argument List of IP addresses of seed nodes in unmanaged data centers. These will be added to the seed node lists of all managed nodes.
     */
    @JvmName("nvsfdtbmghxdvuun")
    public suspend fun externalSeedNodes(vararg argument: suspend SeedNodeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SeedNodeArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.externalSeedNodes = mapped
    }

    /**
     * @param argument List of IP addresses of seed nodes in unmanaged data centers. These will be added to the seed node lists of all managed nodes.
     */
    @JvmName("ibluoqncvvqmeehb")
    public suspend fun externalSeedNodes(argument: suspend SeedNodeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SeedNodeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.externalSeedNodes = mapped
    }

    /**
     * @param values List of IP addresses of seed nodes in unmanaged data centers. These will be added to the seed node lists of all managed nodes.
     */
    @JvmName("qtqapahihixswjbk")
    public suspend fun externalSeedNodes(vararg values: SeedNodeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.externalSeedNodes = mapped
    }

    /**
     * @param value (Deprecated) Number of hours to wait between taking a backup of the cluster.
     */
    @JvmName("ajatonqcaavplgmj")
    public suspend fun hoursBetweenBackups(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hoursBetweenBackups = mapped
    }

    /**
     * @param value Initial password for clients connecting as admin to the cluster. Should be changed after cluster creation. Returns null on GET. This field only applies when the authenticationMethod field is 'Cassandra'.
     */
    @JvmName("loxvsqeawosuidjp")
    public suspend fun initialCassandraAdminPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initialCassandraAdminPassword = mapped
    }

    /**
     * @param value Hostname or IP address where the Prometheus endpoint containing data about the managed Cassandra nodes can be reached.
     */
    @JvmName("fblrjvfhecthepky")
    public suspend fun prometheusEndpoint(`value`: SeedNodeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prometheusEndpoint = mapped
    }

    /**
     * @param argument Hostname or IP address where the Prometheus endpoint containing data about the managed Cassandra nodes can be reached.
     */
    @JvmName("sbirirywbmtvxnuc")
    public suspend fun prometheusEndpoint(argument: suspend SeedNodeArgsBuilder.() -> Unit) {
        val toBeMapped = SeedNodeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.prometheusEndpoint = mapped
    }

    /**
     * @param value Error related to resource provisioning.
     */
    @JvmName("nkvrsjkbaegutfts")
    public suspend fun provisionError(`value`: CassandraErrorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisionError = mapped
    }

    /**
     * @param argument Error related to resource provisioning.
     */
    @JvmName("gjljsfowtlyfxika")
    public suspend fun provisionError(argument: suspend CassandraErrorArgsBuilder.() -> Unit) {
        val toBeMapped = CassandraErrorArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.provisionError = mapped
    }

    /**
     * @param value The status of the resource at the time the operation was called.
     */
    @JvmName("dvacmhnhbqfvircr")
    public suspend
    fun provisioningState(`value`: Either<String, ManagedCassandraProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The status of the resource at the time the operation was called.
     */
    @JvmName("svnmwljfesyjevcr")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ManagedCassandraProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The status of the resource at the time the operation was called.
     */
    @JvmName("pjaolxxcdsqxkocy")
    public fun provisioningState(`value`: ManagedCassandraProvisioningState) {
        val toBeMapped = Either.ofRight<String, ManagedCassandraProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Should automatic repairs run on this cluster? If omitted, this is true, and should stay true unless you are running a hybrid cluster where you are already doing your own repairs.
     */
    @JvmName("paotlisoclydimtr")
    public suspend fun repairEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repairEnabled = mapped
    }

    /**
     * @param value To create an empty cluster, omit this field or set it to null. To restore a backup into a new cluster, set this field to the resource id of the backup.
     */
    @JvmName("yvononhoxpaxaovp")
    public suspend fun restoreFromBackupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restoreFromBackupId = mapped
    }

    internal fun build(): ClusterResourcePropertiesArgs = ClusterResourcePropertiesArgs(
        authenticationMethod = authenticationMethod,
        cassandraAuditLoggingEnabled = cassandraAuditLoggingEnabled,
        cassandraVersion = cassandraVersion,
        clientCertificates = clientCertificates,
        clusterNameOverride = clusterNameOverride,
        deallocated = deallocated,
        delegatedManagementSubnetId = delegatedManagementSubnetId,
        externalGossipCertificates = externalGossipCertificates,
        externalSeedNodes = externalSeedNodes,
        hoursBetweenBackups = hoursBetweenBackups,
        initialCassandraAdminPassword = initialCassandraAdminPassword,
        prometheusEndpoint = prometheusEndpoint,
        provisionError = provisionError,
        provisioningState = provisioningState,
        repairEnabled = repairEnabled,
        restoreFromBackupId = restoreFromBackupId,
    )
}
