@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.ColumnArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Cosmos DB Cassandra table column
 * @property name Name of the Cosmos DB Cassandra table column
 * @property type Type of the Cosmos DB Cassandra table column
 */
public data class ColumnArgs(
    public val name: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.ColumnArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.ColumnArgs =
        com.pulumi.azurenative.documentdb.inputs.ColumnArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ColumnArgs].
 */
@PulumiTagMarker
public class ColumnArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Name of the Cosmos DB Cassandra table column
     */
    @JvmName("mfrwmivcyshpwfyl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Type of the Cosmos DB Cassandra table column
     */
    @JvmName("putthbbpnetaxfpj")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Name of the Cosmos DB Cassandra table column
     */
    @JvmName("eborqjtakyxdutan")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Type of the Cosmos DB Cassandra table column
     */
    @JvmName("avybacqyptbskmjr")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ColumnArgs = ColumnArgs(
        name = name,
        type = type,
    )
}
