@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.CompositePathArgs.builder
import com.pulumi.azurenative.documentdb.kotlin.enums.CompositePathSortOrder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property order Sort order for composite paths.
 * @property path The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
 * */
 */
public data class CompositePathArgs(
    public val order: Output<Either<String, CompositePathSortOrder>>? = null,
    public val path: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.CompositePathArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.CompositePathArgs =
        com.pulumi.azurenative.documentdb.inputs.CompositePathArgs.builder()
            .order(
                order?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .path(path?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CompositePathArgs].
 */
@PulumiTagMarker
public class CompositePathArgsBuilder internal constructor() {
    private var order: Output<Either<String, CompositePathSortOrder>>? = null

    private var path: Output<String>? = null

    /**
     * @param value Sort order for composite paths.
     */
    @JvmName("krhkjvsjyfihvefy")
    public suspend fun order(`value`: Output<Either<String, CompositePathSortOrder>>) {
        this.order = value
    }

    /**
     * @param value The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
     * */
     */
    @JvmName("hlssquomjfyosqro")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value Sort order for composite paths.
     */
    @JvmName("ttjpqncydrtqfstl")
    public suspend fun order(`value`: Either<String, CompositePathSortOrder>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.order = mapped
    }

    /**
     * @param value Sort order for composite paths.
     */
    @JvmName("trjybicaaiaoqlsf")
    public fun order(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CompositePathSortOrder>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.order = mapped
    }

    /**
     * @param value Sort order for composite paths.
     */
    @JvmName("csvtsipgwmimvrqt")
    public fun order(`value`: CompositePathSortOrder) {
        val toBeMapped = Either.ofRight<String, CompositePathSortOrder>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.order = mapped
    }

    /**
     * @param value The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
     * */
     */
    @JvmName("eevhniyiojartonv")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    internal fun build(): CompositePathArgs = CompositePathArgs(
        order = order,
        path = path,
    )
}
