@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.CreateUpdateOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * CreateUpdateOptions are a list of key-value pairs that describe the resource. Supported keys are "If-Match", "If-None-Match", "Session-Token" and "Throughput"
 * @property autoscaleSettings Specifies the Autoscale settings.
 * @property throughput Request Units per second. For example, "throughput": 10000.
 */
public data class CreateUpdateOptionsArgs(
    public val autoscaleSettings: Output<AutoscaleSettingsArgs>? = null,
    public val throughput: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.CreateUpdateOptionsArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.CreateUpdateOptionsArgs =
        com.pulumi.azurenative.documentdb.inputs.CreateUpdateOptionsArgs.builder()
            .autoscaleSettings(autoscaleSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .throughput(throughput?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CreateUpdateOptionsArgs].
 */
@PulumiTagMarker
public class CreateUpdateOptionsArgsBuilder internal constructor() {
    private var autoscaleSettings: Output<AutoscaleSettingsArgs>? = null

    private var throughput: Output<Int>? = null

    /**
     * @param value Specifies the Autoscale settings.
     */
    @JvmName("aavxrjpjeefetwip")
    public suspend fun autoscaleSettings(`value`: Output<AutoscaleSettingsArgs>) {
        this.autoscaleSettings = value
    }

    /**
     * @param value Request Units per second. For example, "throughput": 10000.
     */
    @JvmName("gxlgdlhwwpvkhtby")
    public suspend fun throughput(`value`: Output<Int>) {
        this.throughput = value
    }

    /**
     * @param value Specifies the Autoscale settings.
     */
    @JvmName("wbgaebeajixxrstr")
    public suspend fun autoscaleSettings(`value`: AutoscaleSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoscaleSettings = mapped
    }

    /**
     * @param argument Specifies the Autoscale settings.
     */
    @JvmName("ovulpnoclascpbbf")
    public suspend fun autoscaleSettings(argument: suspend AutoscaleSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = AutoscaleSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.autoscaleSettings = mapped
    }

    /**
     * @param value Request Units per second. For example, "throughput": 10000.
     */
    @JvmName("akkeoxegerpiojdr")
    public suspend fun throughput(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throughput = mapped
    }

    internal fun build(): CreateUpdateOptionsArgs = CreateUpdateOptionsArgs(
        autoscaleSettings = autoscaleSettings,
        throughput = throughput,
    )
}
