@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.DatabaseRestoreResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Specific Databases to restore.
 * @property collectionNames The names of the collections available for restore.
 * @property databaseName The name of the database available for restore.
 */
public data class DatabaseRestoreResourceArgs(
    public val collectionNames: Output<List<String>>? = null,
    public val databaseName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.DatabaseRestoreResourceArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.DatabaseRestoreResourceArgs =
        com.pulumi.azurenative.documentdb.inputs.DatabaseRestoreResourceArgs.builder()
            .collectionNames(collectionNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .databaseName(databaseName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DatabaseRestoreResourceArgs].
 */
@PulumiTagMarker
public class DatabaseRestoreResourceArgsBuilder internal constructor() {
    private var collectionNames: Output<List<String>>? = null

    private var databaseName: Output<String>? = null

    /**
     * @param value The names of the collections available for restore.
     */
    @JvmName("ralwpqfdifyoegro")
    public suspend fun collectionNames(`value`: Output<List<String>>) {
        this.collectionNames = value
    }

    @JvmName("gmqvrtlwlwnvkvwn")
    public suspend fun collectionNames(vararg values: Output<String>) {
        this.collectionNames = Output.all(values.asList())
    }

    /**
     * @param values The names of the collections available for restore.
     */
    @JvmName("inahoxkyjqcrlakq")
    public suspend fun collectionNames(values: List<Output<String>>) {
        this.collectionNames = Output.all(values)
    }

    /**
     * @param value The name of the database available for restore.
     */
    @JvmName("goavuvwmeqevckdc")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The names of the collections available for restore.
     */
    @JvmName("ohbuombuqsvahrds")
    public suspend fun collectionNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.collectionNames = mapped
    }

    /**
     * @param values The names of the collections available for restore.
     */
    @JvmName("vwjelqmlervnuubj")
    public suspend fun collectionNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.collectionNames = mapped
    }

    /**
     * @param value The name of the database available for restore.
     */
    @JvmName("cftdtijqdphhnemk")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    internal fun build(): DatabaseRestoreResourceArgs = DatabaseRestoreResourceArgs(
        collectionNames = collectionNames,
        databaseName = databaseName,
    )
}
