@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.GetCassandraResourceCassandraTablePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName Cosmos DB database account name.
 * @property keyspaceName Cosmos DB keyspace name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tableName Cosmos DB table name.
 */
public data class GetCassandraResourceCassandraTablePlainArgs(
    public val accountName: String,
    public val keyspaceName: String,
    public val resourceGroupName: String,
    public val tableName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.GetCassandraResourceCassandraTablePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.documentdb.inputs.GetCassandraResourceCassandraTablePlainArgs =
        com.pulumi.azurenative.documentdb.inputs.GetCassandraResourceCassandraTablePlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .keyspaceName(keyspaceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .tableName(tableName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCassandraResourceCassandraTablePlainArgs].
 */
@PulumiTagMarker
public class GetCassandraResourceCassandraTablePlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var keyspaceName: String? = null

    private var resourceGroupName: String? = null

    private var tableName: String? = null

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("uaotspggkpbawvmx")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value Cosmos DB keyspace name.
     */
    @JvmName("djiapgwjsinlkiwy")
    public suspend fun keyspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.keyspaceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xhlwodcanfwqsldg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Cosmos DB table name.
     */
    @JvmName("kgrynnbofmasjekj")
    public suspend fun tableName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tableName = mapped
    }

    internal fun build(): GetCassandraResourceCassandraTablePlainArgs =
        GetCassandraResourceCassandraTablePlainArgs(
            accountName = accountName ?: throw PulumiNullFieldException("accountName"),
            keyspaceName = keyspaceName ?: throw PulumiNullFieldException("keyspaceName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            tableName = tableName ?: throw PulumiNullFieldException("tableName"),
        )
}
