@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.GetGraphResourceGraphPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName Cosmos DB database account name.
 * @property graphName Cosmos DB graph resource name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetGraphResourceGraphPlainArgs(
    public val accountName: String,
    public val graphName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.GetGraphResourceGraphPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.GetGraphResourceGraphPlainArgs =
        com.pulumi.azurenative.documentdb.inputs.GetGraphResourceGraphPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .graphName(graphName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGraphResourceGraphPlainArgs].
 */
@PulumiTagMarker
public class GetGraphResourceGraphPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var graphName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("krkhhalhkmsphyaa")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value Cosmos DB graph resource name.
     */
    @JvmName("ccpvtpsmqkbbobis")
    public suspend fun graphName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.graphName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kouvtwugwyhpdmgw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetGraphResourceGraphPlainArgs = GetGraphResourceGraphPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        graphName = graphName ?: throw PulumiNullFieldException("graphName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
