@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.GetGremlinResourceGremlinGraphPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName Cosmos DB database account name.
 * @property databaseName Cosmos DB database name.
 * @property graphName Cosmos DB graph name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetGremlinResourceGremlinGraphPlainArgs(
    public val accountName: String,
    public val databaseName: String,
    public val graphName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.GetGremlinResourceGremlinGraphPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.documentdb.inputs.GetGremlinResourceGremlinGraphPlainArgs =
        com.pulumi.azurenative.documentdb.inputs.GetGremlinResourceGremlinGraphPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .databaseName(databaseName.let({ args0 -> args0 }))
            .graphName(graphName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGremlinResourceGremlinGraphPlainArgs].
 */
@PulumiTagMarker
public class GetGremlinResourceGremlinGraphPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var databaseName: String? = null

    private var graphName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("xbynmjblrtxvsxby")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value Cosmos DB database name.
     */
    @JvmName("nkeoarkfaunkgwgr")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseName = mapped
    }

    /**
     * @param value Cosmos DB graph name.
     */
    @JvmName("ccbeigofproyeqtd")
    public suspend fun graphName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.graphName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cleldysjwjxwjbvs")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetGremlinResourceGremlinGraphPlainArgs =
        GetGremlinResourceGremlinGraphPlainArgs(
            accountName = accountName ?: throw PulumiNullFieldException("accountName"),
            databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
            graphName = graphName ?: throw PulumiNullFieldException("graphName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
