@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.GetMongoDBResourceMongoRoleDefinitionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName Cosmos DB database account name.
 * @property mongoRoleDefinitionId The ID for the Role Definition {dbName.roleName}.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetMongoDBResourceMongoRoleDefinitionPlainArgs(
    public val accountName: String,
    public val mongoRoleDefinitionId: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.GetMongoDBResourceMongoRoleDefinitionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.documentdb.inputs.GetMongoDBResourceMongoRoleDefinitionPlainArgs =
        com.pulumi.azurenative.documentdb.inputs.GetMongoDBResourceMongoRoleDefinitionPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .mongoRoleDefinitionId(mongoRoleDefinitionId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMongoDBResourceMongoRoleDefinitionPlainArgs].
 */
@PulumiTagMarker
public class GetMongoDBResourceMongoRoleDefinitionPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var mongoRoleDefinitionId: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("wfecjlnernxmytrc")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The ID for the Role Definition {dbName.roleName}.
     */
    @JvmName("aipdigedeyeyxhha")
    public suspend fun mongoRoleDefinitionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.mongoRoleDefinitionId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cobmhxwhjgoxaxvm")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetMongoDBResourceMongoRoleDefinitionPlainArgs =
        GetMongoDBResourceMongoRoleDefinitionPlainArgs(
            accountName = accountName ?: throw PulumiNullFieldException("accountName"),
            mongoRoleDefinitionId = mongoRoleDefinitionId ?: throw
                PulumiNullFieldException("mongoRoleDefinitionId"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
