@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.GetNotebookWorkspacePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName Cosmos DB database account name.
 * @property notebookWorkspaceName The name of the notebook workspace resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetNotebookWorkspacePlainArgs(
    public val accountName: String,
    public val notebookWorkspaceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.GetNotebookWorkspacePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.GetNotebookWorkspacePlainArgs =
        com.pulumi.azurenative.documentdb.inputs.GetNotebookWorkspacePlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .notebookWorkspaceName(notebookWorkspaceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNotebookWorkspacePlainArgs].
 */
@PulumiTagMarker
public class GetNotebookWorkspacePlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var notebookWorkspaceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("kypigtfrxabvonvl")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the notebook workspace resource.
     */
    @JvmName("bvjsnqvbfqrnhrxw")
    public suspend fun notebookWorkspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.notebookWorkspaceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("epawwdnqvhbyxkhu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNotebookWorkspacePlainArgs = GetNotebookWorkspacePlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        notebookWorkspaceName = notebookWorkspaceName ?: throw
            PulumiNullFieldException("notebookWorkspaceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
