@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.GetSqlResourceSqlRoleAssignmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName Cosmos DB database account name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property roleAssignmentId The GUID for the Role Assignment.
 */
public data class GetSqlResourceSqlRoleAssignmentPlainArgs(
    public val accountName: String,
    public val resourceGroupName: String,
    public val roleAssignmentId: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.GetSqlResourceSqlRoleAssignmentPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.documentdb.inputs.GetSqlResourceSqlRoleAssignmentPlainArgs =
        com.pulumi.azurenative.documentdb.inputs.GetSqlResourceSqlRoleAssignmentPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .roleAssignmentId(roleAssignmentId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSqlResourceSqlRoleAssignmentPlainArgs].
 */
@PulumiTagMarker
public class GetSqlResourceSqlRoleAssignmentPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var resourceGroupName: String? = null

    private var roleAssignmentId: String? = null

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("sffnpnkyctoupgvw")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ganqescvhbdkwunm")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The GUID for the Role Assignment.
     */
    @JvmName("ofidiyyorodvfder")
    public suspend fun roleAssignmentId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.roleAssignmentId = mapped
    }

    internal fun build(): GetSqlResourceSqlRoleAssignmentPlainArgs =
        GetSqlResourceSqlRoleAssignmentPlainArgs(
            accountName = accountName ?: throw PulumiNullFieldException("accountName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            roleAssignmentId = roleAssignmentId ?: throw PulumiNullFieldException("roleAssignmentId"),
        )
}
