@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.GetThroughputPoolAccountPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property throughputPoolAccountName Cosmos DB global database account in a Throughput Pool
 * @property throughputPoolName Cosmos DB Throughput Pool name.
 */
public data class GetThroughputPoolAccountPlainArgs(
    public val resourceGroupName: String,
    public val throughputPoolAccountName: String,
    public val throughputPoolName: String,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.GetThroughputPoolAccountPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.GetThroughputPoolAccountPlainArgs =
        com.pulumi.azurenative.documentdb.inputs.GetThroughputPoolAccountPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .throughputPoolAccountName(throughputPoolAccountName.let({ args0 -> args0 }))
            .throughputPoolName(throughputPoolName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetThroughputPoolAccountPlainArgs].
 */
@PulumiTagMarker
public class GetThroughputPoolAccountPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var throughputPoolAccountName: String? = null

    private var throughputPoolName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ohxtvfcglsrnqiia")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Cosmos DB global database account in a Throughput Pool
     */
    @JvmName("mcrovuwlpqvyujla")
    public suspend fun throughputPoolAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.throughputPoolAccountName = mapped
    }

    /**
     * @param value Cosmos DB Throughput Pool name.
     */
    @JvmName("dgcispusfmogveuo")
    public suspend fun throughputPoolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.throughputPoolName = mapped
    }

    internal fun build(): GetThroughputPoolAccountPlainArgs = GetThroughputPoolAccountPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        throughputPoolAccountName = throughputPoolAccountName ?: throw
            PulumiNullFieldException("throughputPoolAccountName"),
        throughputPoolName = throughputPoolName ?: throw PulumiNullFieldException("throughputPoolName"),
    )
}
