@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.ListDatabaseAccountKeysPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName Cosmos DB database account name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class ListDatabaseAccountKeysPlainArgs(
    public val accountName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.ListDatabaseAccountKeysPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.ListDatabaseAccountKeysPlainArgs =
        com.pulumi.azurenative.documentdb.inputs.ListDatabaseAccountKeysPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListDatabaseAccountKeysPlainArgs].
 */
@PulumiTagMarker
public class ListDatabaseAccountKeysPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("seihfxgfkmrmydap")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vghhixmdwkdtundc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListDatabaseAccountKeysPlainArgs = ListDatabaseAccountKeysPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
